/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.effect.group;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import tnt.tarkovcraft.core.common.data.duration.TickValue;
import tnt.tarkovcraft.medsystem.common.effect.group.EffectGroupItem;
import tnt.tarkovcraft.medsystem.common.effect.group.EffectGroupItemType;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;

public final class EffectGroupHolder {
    public static final Codec<EffectGroupHolder> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EffectGroupItemType.CODEC.fieldOf("data").forGetter(t -> t.item), (App)Codec.INT.fieldOf("duration").forGetter(t -> t.duration), (App)Codec.INT.optionalFieldOf("delay", (Object)0).forGetter(t -> t.delay), (App)Codec.BOOL.optionalFieldOf("active", (Object)false).forGetter(t -> t.active)).apply((Applicative)instance, EffectGroupHolder::new));
    private final EffectGroupItem item;
    private int duration;
    private int delay;
    private boolean active;

    public EffectGroupHolder(EffectGroupItem item, int duration, int delay) {
        this(item, duration, delay, false);
    }

    private EffectGroupHolder(EffectGroupItem item, int duration, int delay, boolean active) {
        this.item = item;
        this.duration = duration;
        this.delay = delay;
        this.active = active;
    }

    public static Factory getFactory(List<EffectGroupHolder> items) {
        return new Factory(items);
    }

    public void tick(HealthContainer container, LivingEntity entity, @Nullable BodyPart limb) {
        if (this.delay > 0 && --this.delay > 0) {
            return;
        }
        if (!this.active) {
            this.active = true;
            this.item.init(this, container, entity, limb);
        }
        this.item.apply(this, container, entity, limb);
        if (--this.duration <= 0) {
            this.cleanUp(container, entity, limb);
        }
    }

    public void cleanUp(HealthContainer container, LivingEntity entity, @Nullable BodyPart limb) {
        this.item.cleanup(this, container, entity, limb);
    }

    public void addInformation(Consumer<Component> tooltip, boolean isItemTooltip) {
        this.item.addInformation(this, tooltip, isItemTooltip);
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isActiveAndVisible() {
        return this.isActive() && this.item.isVisible();
    }

    public boolean isExpired() {
        return this.duration <= 0;
    }

    public EffectGroupItem getItem() {
        return this.item;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getRequiredGroupLifetime() {
        return this.delay + this.duration;
    }

    public EffectGroupHolder tryMerge(EffectGroupHolder other) {
        return this.item.tryToMergeWith(this, other);
    }

    public EffectGroupHolder copy() {
        return new EffectGroupHolder(this.item.copy(), this.duration, this.delay, this.active);
    }

    public static final class Factory {
        private final List<EffectGroupHolder> output;

        public Factory(List<EffectGroupHolder> output) {
            this.output = output;
        }

        public void create(int duration, int delay, EffectGroupItem item) {
            this.output.add(new EffectGroupHolder(item, duration, delay, false));
        }

        public void create(TickValue duration, int delay, EffectGroupItem item) {
            this.create(duration.tickValue(), delay, item);
        }

        public void create(int duration, TickValue delay, EffectGroupItem item) {
            this.create(duration, delay.tickValue(), item);
        }

        public void create(TickValue duration, TickValue delay, EffectGroupItem item) {
            this.create(duration.tickValue(), delay.tickValue(), item);
        }
    }
}

