/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.world.entity.EquipmentSlot;

public enum BodyPartGroup {
    HEAD(0xFF0000, EquipmentSlot.HEAD, new EquipmentSlot[0]),
    TORSO(0xFFFF00, EquipmentSlot.CHEST, new EquipmentSlot[0]),
    STOMACH(65280, EquipmentSlot.CHEST, new EquipmentSlot[0]),
    ARM(65535),
    LEG(255, EquipmentSlot.LEGS, EquipmentSlot.FEET),
    ANIMAL(65280, EquipmentSlot.BODY, new EquipmentSlot[0]),
    OTHER(0x444444),
    INACTIVE(0);

    private final Set<EquipmentSlot> armorSlots;
    private final int hitboxColor;

    private BodyPartGroup(int hitboxColor) {
        this(hitboxColor, null, new EquipmentSlot[0]);
    }

    private BodyPartGroup(int hitboxColor, EquipmentSlot first, EquipmentSlot ... other) {
        this.hitboxColor = hitboxColor;
        this.armorSlots = first != null ? EnumSet.of(first, other) : Collections.emptySet();
    }

    public static EnumSet<BodyPartGroup> getProtectedByEquipment(EquipmentSlot slot) {
        EnumSet<BodyPartGroup> set = EnumSet.noneOf(BodyPartGroup.class);
        for (BodyPartGroup group : BodyPartGroup.values()) {
            if (!group.armorSlots.contains(slot)) continue;
            set.add(group);
        }
        return set;
    }

    public Set<EquipmentSlot> getArmorSlots() {
        return this.armorSlots;
    }

    public int getHitboxColor() {
        return this.hitboxColor;
    }

    public boolean isInactive() {
        return this == INACTIVE;
    }
}

