/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health.math;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;
import tnt.tarkovcraft.medsystem.common.health.BodyPartGroup;
import tnt.tarkovcraft.medsystem.common.health.BodyPartHitbox;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HitResult;
import tnt.tarkovcraft.medsystem.common.health.math.DamageDistributor;
import tnt.tarkovcraft.medsystem.common.health.math.HitCalculator;
import tnt.tarkovcraft.medsystem.common.health.math.ScaledDamageDistributor;

public class LavaHitCalculator
implements HitCalculator {
    public static final LavaHitCalculator INSTANCE = new LavaHitCalculator();

    @Override
    public List<HitResult> calculateHits(LivingEntity entity, DamageSource source, HealthContainer container) {
        ArrayList<HitResult> hits = new ArrayList<HitResult>();
        container.acceptHitboxes((hitbox, part) -> this.isInFluid(entity.level(), hitbox.getLevelPositionedAABB(entity)), (hitbox, bodyPart) -> hits.add(new HitResult((BodyPartHitbox)hitbox, (BodyPart)bodyPart)));
        if (hits.isEmpty()) {
            container.acceptHitboxes((hitbox, part) -> part.getGroup() == BodyPartGroup.LEG, (hitbox, part) -> hits.add(new HitResult((BodyPartHitbox)hitbox, (BodyPart)part)));
        }
        return hits;
    }

    @Override
    public DamageDistributor getCustomDamageDistributor(LivingEntity entity, DamageSource source, HealthContainer container, DamageDistributor original) {
        return new ScaledDamageDistributor(2.5f, original);
    }

    protected boolean isInFluid(Level level, AABB aabb) {
        Vec3 pos = aabb.getCenter();
        FluidState state = level.getFluidState(new BlockPos(Mth.floor((double)pos.x), Mth.floor((double)pos.y), Mth.floor((double)pos.z)));
        return !state.isEmpty();
    }
}

