/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health.math;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import tnt.tarkovcraft.medsystem.common.health.BodyPartHitbox;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HealthSystem;
import tnt.tarkovcraft.medsystem.common.health.HitResult;
import tnt.tarkovcraft.medsystem.common.health.PositionedAABB;
import tnt.tarkovcraft.medsystem.common.health.math.DamageDistributor;
import tnt.tarkovcraft.medsystem.common.health.math.DecayingDamageDistributor;
import tnt.tarkovcraft.medsystem.common.health.math.HitCalculator;

public class ProjectileHitCalculator
implements HitCalculator {
    public static final ProjectileHitCalculator INSTANCE = new ProjectileHitCalculator(0.3);
    private final double aabbInflate;

    public ProjectileHitCalculator(double aabbInflate) {
        this.aabbInflate = aabbInflate;
    }

    @Override
    public List<HitResult> calculateHits(LivingEntity entity, DamageSource source, HealthContainer container) {
        Entity projectile = source.getDirectEntity();
        Vec3 position = projectile.getBoundingBox().getCenter();
        Vec3 destPosition = position.add(projectile.getDeltaMovement().scale(2.5));
        int pierceAmount = HealthSystem.getProjectilePiercing(entity, source, container, projectile);
        List<BodyPartHitbox> hitboxes = container.getDefinition().getHitboxes();
        ArrayList<HitResult> hits = new ArrayList<HitResult>();
        for (BodyPartHitbox hitbox2 : hitboxes) {
            AABB axisAlignedBB = PositionedAABB.inflate(hitbox2.getLevelPositionedAABB(entity), this.aabbInflate);
            Optional<Vec3> intersect = PositionedAABB.tryIntersect(axisAlignedBB, position, destPosition);
            intersect.ifPresent(hit -> hits.add(new HitResult(hitbox2, container.getBodyPart(hitbox2.getOwner()), axisAlignedBB, (Vec3)hit)));
        }
        hits.sort(Comparator.comparingDouble(res -> res.aabb().distanceToSqr(position)));
        if (!hits.isEmpty()) {
            return hits.subList(0, Math.min(hits.size(), pierceAmount));
        }
        List<HitResult> closest = HealthSystem.getClosestPossibleHits(position, entity, container, (hitbox, part) -> true);
        return closest.isEmpty() ? Collections.emptyList() : Collections.singletonList(closest.getFirst());
    }

    @Override
    public DamageDistributor getCustomDamageDistributor(LivingEntity entity, DamageSource source, HealthContainer container, DamageDistributor original) {
        return DecayingDamageDistributor.PROJECTILE;
    }
}

