/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health.reaction;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.LivingEntity;
import tnt.tarkovcraft.core.common.data.number.NumberProvider;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.reaction.ChanceHealthEventSource;
import tnt.tarkovcraft.medsystem.common.health.reaction.HealthEventSourceType;
import tnt.tarkovcraft.medsystem.common.health.reaction.function.ChanceFunction;
import tnt.tarkovcraft.medsystem.common.init.MedSystemHealthReactions;

public class DamageSourceHealthEventSource
extends ChanceHealthEventSource {
    public static final MapCodec<DamageSourceHealthEventSource> CODEC = RecordCodecBuilder.mapCodec(instance -> DamageSourceHealthEventSource.common(instance).and((App)TagKey.codec((ResourceKey)Registries.DAMAGE_TYPE).fieldOf("source").forGetter(t -> t.damageType)).apply((Applicative)instance, DamageSourceHealthEventSource::new));
    private final TagKey<DamageType> damageType;

    public DamageSourceHealthEventSource(Either<NumberProvider, Float> baseChance, List<ChanceFunction> functions, TagKey<DamageType> damageType) {
        super(baseChance, functions);
        this.damageType = damageType;
    }

    @Override
    public boolean canReact(HealthContainer container, LivingEntity entity, @Nullable DamageSource damageSource, BodyPart limb) {
        if (damageSource == null) {
            return false;
        }
        if (!damageSource.is(this.damageType)) {
            return false;
        }
        return super.canReact(container, entity, damageSource, limb);
    }

    @Override
    public HealthEventSourceType<?> getType() {
        return MedSystemHealthReactions.DAMAGE_SOURCE.get();
    }
}

