/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health.transform;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import tnt.tarkovcraft.core.util.Codecs;
import tnt.tarkovcraft.medsystem.common.health.PositionedAABB;
import tnt.tarkovcraft.medsystem.common.health.transform.EntityHitboxTransform;
import tnt.tarkovcraft.medsystem.common.health.transform.EntityHitboxTransformType;
import tnt.tarkovcraft.medsystem.common.health.transform.TransformCondition;
import tnt.tarkovcraft.medsystem.common.health.transform.TransformConditionType;

public record HitboxTransformDefinition(List<TransformCondition> conditions, List<EntityHitboxTransform> transforms) {
    public static final Codec<HitboxTransformDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.list(TransformConditionType.CODEC).optionalFieldOf("if", Collections.emptyList()).forGetter(HitboxTransformDefinition::conditions), (App)Codecs.list(EntityHitboxTransformType.CODEC).fieldOf("apply").forGetter(HitboxTransformDefinition::transforms)).apply((Applicative)instance, HitboxTransformDefinition::new));

    public boolean canApplyTransform(LivingEntity entity) {
        for (TransformCondition condition : this.conditions) {
            if (condition.canApply(entity)) continue;
            return false;
        }
        return true;
    }

    public PositionedAABB apply(PositionedAABB aabb, LivingEntity entity) {
        if (this.canApplyTransform(entity)) {
            for (EntityHitboxTransform transform : this.transforms) {
                aabb = transform.apply(aabb, entity);
            }
        }
        return aabb;
    }
}

