/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.init;

import java.util.function.BiConsumer;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import tnt.tarkovcraft.core.common.data.duration.Duration;
import tnt.tarkovcraft.core.common.data.duration.TickValue;
import tnt.tarkovcraft.medsystem.MedicalSystem;
import tnt.tarkovcraft.medsystem.api.heal.SideEffectHolder;
import tnt.tarkovcraft.medsystem.common.config.StatusEffectConfig;
import tnt.tarkovcraft.medsystem.common.effect.group.BloodRecoveryEffectGroupItem;
import tnt.tarkovcraft.medsystem.common.effect.group.EffectGroupItem;

public final class VanillaItemComponentAssignments {
    public static void adjustItemData(BiConsumer<ItemLike, SideEffectHolder> registration) {
        MedicalSystem.LOGGER.debug(MedicalSystem.MARKER, "Applying consumption/hit effects to vanilla items");
        StatusEffectConfig config = MedicalSystem.getConfig().statusEffects;
        int effectDuration = config.itemStatusEffectDuration;
        SideEffectHolder swords = config.swordStatusEffects.apply(SideEffectHolder.builder(), effectDuration).title(SideEffectHolder.ITEM_TITLE).build();
        registration.accept((ItemLike)Items.WOODEN_SWORD, swords);
        registration.accept((ItemLike)Items.STONE_SWORD, swords);
        registration.accept((ItemLike)Items.IRON_SWORD, swords);
        registration.accept((ItemLike)Items.GOLDEN_SWORD, swords);
        registration.accept((ItemLike)Items.DIAMOND_SWORD, swords);
        registration.accept((ItemLike)Items.NETHERITE_SWORD, swords);
        SideEffectHolder axes = config.axeStatusEffects.apply(SideEffectHolder.builder(), effectDuration).title(SideEffectHolder.ITEM_TITLE).build();
        registration.accept((ItemLike)Items.WOODEN_AXE, axes);
        registration.accept((ItemLike)Items.STONE_AXE, axes);
        registration.accept((ItemLike)Items.IRON_AXE, axes);
        registration.accept((ItemLike)Items.GOLDEN_AXE, axes);
        registration.accept((ItemLike)Items.DIAMOND_AXE, axes);
        registration.accept((ItemLike)Items.NETHERITE_AXE, axes);
        SideEffectHolder blunt = config.bluntStatusEffects.apply(SideEffectHolder.builder(), effectDuration).title(SideEffectHolder.ITEM_TITLE).build();
        registration.accept((ItemLike)Items.WOODEN_SHOVEL, blunt);
        registration.accept((ItemLike)Items.STONE_SHOVEL, blunt);
        registration.accept((ItemLike)Items.IRON_SHOVEL, blunt);
        registration.accept((ItemLike)Items.GOLDEN_SHOVEL, blunt);
        registration.accept((ItemLike)Items.DIAMOND_SHOVEL, blunt);
        registration.accept((ItemLike)Items.NETHERITE_SHOVEL, blunt);
        registration.accept((ItemLike)Items.WOODEN_PICKAXE, blunt);
        registration.accept((ItemLike)Items.STONE_PICKAXE, blunt);
        registration.accept((ItemLike)Items.IRON_PICKAXE, blunt);
        registration.accept((ItemLike)Items.GOLDEN_PICKAXE, blunt);
        registration.accept((ItemLike)Items.DIAMOND_PICKAXE, blunt);
        registration.accept((ItemLike)Items.NETHERITE_PICKAXE, blunt);
        registration.accept((ItemLike)Items.WOODEN_HOE, blunt);
        registration.accept((ItemLike)Items.STONE_HOE, blunt);
        registration.accept((ItemLike)Items.IRON_HOE, blunt);
        registration.accept((ItemLike)Items.GOLDEN_HOE, blunt);
        registration.accept((ItemLike)Items.DIAMOND_HOE, blunt);
        registration.accept((ItemLike)Items.NETHERITE_HOE, blunt);
        registration.accept((ItemLike)Items.MACE, blunt);
        SideEffectHolder bloodRegeneration = SideEffectHolder.builder().buffs(builder -> builder.create((TickValue)Duration.minutes((int)2), (TickValue)Duration.minutes((int)1), (EffectGroupItem)new BloodRecoveryEffectGroupItem(0.002f))).build();
        registration.accept((ItemLike)Items.PUMPKIN_PIE, bloodRegeneration);
        registration.accept((ItemLike)Items.COOKED_COD, bloodRegeneration);
        registration.accept((ItemLike)Items.COOKED_SALMON, bloodRegeneration);
        registration.accept((ItemLike)Items.BEETROOT_SOUP, bloodRegeneration);
        registration.accept((ItemLike)Items.MUSHROOM_STEW, bloodRegeneration);
        registration.accept((ItemLike)Items.GOLDEN_APPLE, bloodRegeneration);
        registration.accept((ItemLike)Items.ENCHANTED_GOLDEN_APPLE, bloodRegeneration);
        registration.accept((ItemLike)Items.GOLDEN_CARROT, bloodRegeneration);
    }
}

