/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.item;

import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import tnt.tarkovcraft.medsystem.common.init.MedSystemItemComponents;
import tnt.tarkovcraft.medsystem.common.item.InteractableItem;
import tnt.tarkovcraft.medsystem.common.item.InteractionTarget;
import tnt.tarkovcraft.medsystem.common.status.BloodContainer;
import tnt.tarkovcraft.medsystem.common.status.BloodData;
import tnt.tarkovcraft.medsystem.common.status.BloodStatus;
import tnt.tarkovcraft.medsystem.common.status.BloodSystem;

public class BloodBagItem
extends InteractableItem {
    public BloodBagItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected boolean canUseItem(ItemStack itemStack, LivingEntity target, LivingEntity origin) {
        if (!super.canUseItem(itemStack, target, origin)) {
            return false;
        }
        BloodContainer container = this.getContainer(itemStack);
        if (container == null) {
            return false;
        }
        if (!BloodSystem.hasBloodDataIntegration(target)) {
            return false;
        }
        BloodData bloodData = BloodSystem.getBloodData(target);
        boolean refillMode = this.isRefillMode(container, bloodData);
        return refillMode || !bloodData.hasFullBloodVolume();
    }

    @Override
    protected boolean tryInitiateExistingInteraction(ItemStack itemStack, InteractionTarget interaction, LivingEntity target, Player origin) {
        return false;
    }

    @Override
    protected InteractionResult initiateInteraction(ItemStack itemStack, InteractionTarget.Mutable interaction, LivingEntity target, Player origin) {
        return InteractionResult.SUCCESS;
    }

    @Override
    protected boolean updateInteraction(Level level, ItemStack itemStack, InteractionTarget interaction, LivingEntity target, LivingEntity origin, int remainingUseTicks) {
        return true;
    }

    @Override
    protected ItemStack finishInteraction(ItemStack itemStack, InteractionTarget interaction, LivingEntity target, LivingEntity origin) {
        BloodContainer updated;
        BloodData bloodData;
        BloodContainer container = this.getContainer(itemStack);
        boolean refillMode = this.isRefillMode(container, bloodData = BloodSystem.getBloodData(target));
        if (refillMode) {
            float fillAmount = Math.min(container.getMissingCapacity(), bloodData.getBloodVolume());
            float extracted = bloodData.extract(fillAmount);
            updated = container.fill(extracted);
        } else {
            float extractionAmount = Math.min(container.value(), bloodData.getMissingBloodVolume());
            float filled = bloodData.insert(extractionAmount);
            updated = container.extract(filled);
        }
        if (updated.isEmpty() && !updated.refillable()) {
            itemStack.consume(1, target);
        } else {
            itemStack.set(MedSystemItemComponents.BLOOD_CONTAINER, (Object)updated);
        }
        return itemStack;
    }

    @Override
    @Nullable
    protected Component getInteractionLabel(ItemStack itemStack, InteractionTarget interaction, LivingEntity target, LivingEntity origin, int time, boolean infinite) {
        String key;
        BloodData bloodData;
        BloodContainer container = this.getContainer(itemStack);
        boolean refillMode = this.isRefillMode(container, bloodData = BloodSystem.getBloodData(target));
        String string = key = refillMode ? "label.medsystem.blood_extraction" : "label.medsystem.blood_insertion";
        if (interaction.self()) {
            return Component.translatable((String)(key + ".self"), (Object[])new Object[]{BloodBagItem.formatUsageDuration(time)});
        }
        return Component.translatable((String)(key + ".other"), (Object[])new Object[]{target.getDisplayName(), BloodBagItem.formatUsageDuration(time)});
    }

    @Override
    protected boolean canInteractWithEntity(ItemStack stack, LivingEntity entity, LivingEntity origin) {
        return BloodSystem.hasBloodDataIntegration(entity);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        BloodContainer container = this.getContainer(stack);
        if (container == null) {
            return;
        }
        MutableComponent value = Component.translatable((String)"label.medsystem.unit.liter", (Object[])new Object[]{String.format(Locale.ROOT, "%.2f", Float.valueOf(container.value()))}).withStyle(ChatFormatting.RED);
        MutableComponent capacity = Component.translatable((String)"label.medsystem.unit.liter", (Object[])new Object[]{String.format(Locale.ROOT, "%.2f", Float.valueOf(container.capacity()))}).withStyle(ChatFormatting.RED);
        tooltipAdder.accept((Component)Component.translatable((String)"label.medsystem.blood", (Object[])new Object[]{value, capacity}).withStyle(ChatFormatting.GRAY));
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 200;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BOW;
    }

    private BloodContainer getContainer(ItemStack itemStack) {
        return (BloodContainer)itemStack.get(MedSystemItemComponents.BLOOD_CONTAINER);
    }

    private boolean isRefillMode(BloodContainer container, BloodData data) {
        BloodStatus status = BloodStatus.fromBloodLevelPercentage(data.getBloodVolumePercentage());
        if (!container.refillable()) {
            return false;
        }
        return container.isEmpty() && status.isSameOrAbove(BloodStatus.MODERATE_BLOOD_LOSS) || data.hasFullBloodVolume() && !container.isFull();
    }
}

