/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.item;

import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import tnt.tarkovcraft.medsystem.common.init.MedSystemItemComponents;
import tnt.tarkovcraft.medsystem.common.item.InteractionTarget;
import tnt.tarkovcraft.medsystem.util.InteractionHelper;

public abstract class InteractableItem
extends Item {
    public InteractableItem(Item.Properties properties) {
        super(properties);
    }

    protected static String formatUsageDuration(int time) {
        return String.format(Locale.ROOT, "%.2f", Float.valueOf((float)time / 20.0f));
    }

    protected abstract boolean tryInitiateExistingInteraction(ItemStack var1, InteractionTarget var2, LivingEntity var3, Player var4);

    protected abstract InteractionResult initiateInteraction(ItemStack var1, InteractionTarget.Mutable var2, LivingEntity var3, Player var4);

    protected abstract boolean updateInteraction(Level var1, ItemStack var2, InteractionTarget var3, LivingEntity var4, LivingEntity var5, int var6);

    protected abstract ItemStack finishInteraction(ItemStack var1, InteractionTarget var2, LivingEntity var3, LivingEntity var4);

    public final InteractionResult use(Level level, Player player, InteractionHand hand) {
        LivingEntity target;
        ItemStack itemStack = player.getItemInHand(hand);
        InteractionTarget activeInteraction = this.getActiveInteraction(itemStack);
        if (activeInteraction != null && this.canUseItem(itemStack, target = activeInteraction.getTargetLivingEntity((LivingEntity)player), (LivingEntity)player) && this.tryInitiateExistingInteraction(itemStack, activeInteraction, target, player)) {
            player.startUsingItem(hand);
            return InteractionResult.SUCCESS;
        }
        target = this.findInteractiveTarget(itemStack, (LivingEntity)player);
        if (target == null) {
            this.resetActiveInteraction(itemStack);
            return InteractionResult.FAIL;
        }
        boolean selfInteraction = target == player;
        InteractionTarget.Mutable interaction = new InteractionTarget.Mutable(selfInteraction, selfInteraction ? 0 : target.getId(), "");
        InteractionResult result = this.initiateInteraction(itemStack, interaction, target, player);
        if (result == InteractionResult.SUCCESS) {
            this.setActiveInteraction(itemStack, interaction.toImmutable());
            player.startUsingItem(hand);
        }
        return result;
    }

    public final void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        boolean infinite;
        Component label;
        InteractionTarget interaction = this.getActiveInteraction(stack);
        if (interaction == null) {
            livingEntity.stopUsingItem();
            return;
        }
        LivingEntity target = interaction.getTargetLivingEntity(livingEntity);
        if (target == null) {
            livingEntity.stopUsingItem();
            return;
        }
        if (!this.canUseItem(stack, target, livingEntity)) {
            this.cancelInteractionWithCooldown(stack, livingEntity);
            return;
        }
        boolean interactionTickResult = this.updateInteraction(level, stack, interaction, target, livingEntity, remainingUseDuration);
        if (!interactionTickResult) {
            this.cancelInteractionWithCooldown(stack, livingEntity);
            return;
        }
        if (!level.isClientSide() && (label = this.getInteractionLabel(stack, interaction, target, livingEntity, remainingUseDuration, infinite = this.getUseDuration(stack, livingEntity) >= 72000)) != null && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.displayClientMessage(label, true);
        }
    }

    public final void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        InteractionTarget interaction = this.getActiveInteraction(stack);
        this.onInteractionCancelled(stack, interaction, entity, count);
        if (interaction != null && this.shouldClearInteractionDataOnCancellation(stack, entity, count)) {
            this.resetActiveInteraction(stack);
        }
    }

    public final ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        InteractionTarget interaction = this.getActiveInteraction(stack);
        LivingEntity target = interaction.getTargetLivingEntity(livingEntity);
        if (target == null) {
            this.resetActiveInteraction(stack);
            return stack;
        }
        if (!this.canUseItem(stack, target, livingEntity)) {
            this.resetActiveInteraction(stack);
            return stack;
        }
        ItemStack result = this.finishInteraction(stack, interaction, target, livingEntity);
        this.resetActiveInteraction(result);
        InteractionHelper.addCooldown(livingEntity, result, 10);
        return result;
    }

    protected boolean canUseItem(ItemStack itemStack, LivingEntity target, LivingEntity origin) {
        Player player;
        if (target != origin && origin.distanceToSqr((Entity)target) > 10.0) {
            return false;
        }
        return !(origin instanceof Player) || !(player = (Player)origin).getCooldowns().isOnCooldown(itemStack);
    }

    protected boolean canInteractWithEntity(ItemStack stack, LivingEntity entity, LivingEntity origin) {
        return true;
    }

    protected boolean shouldClearInteractionDataOnCancellation(ItemStack itemStack, LivingEntity entity, int count) {
        return true;
    }

    protected void onInteractionCancelled(ItemStack itemStack, InteractionTarget activeInteraction, LivingEntity entity, int count) {
    }

    @Nullable
    protected Component getInteractionLabel(ItemStack itemStack, InteractionTarget interaction, LivingEntity target, LivingEntity origin, int time, boolean infinite) {
        return null;
    }

    protected final InteractionTarget getActiveInteraction(ItemStack itemStack) {
        return (InteractionTarget)itemStack.get(MedSystemItemComponents.INTERACTION_TARGET);
    }

    protected final void setActiveInteraction(ItemStack itemStack, InteractionTarget target) {
        itemStack.set(MedSystemItemComponents.INTERACTION_TARGET, (Object)target);
    }

    protected final void resetActiveInteraction(ItemStack itemStack) {
        itemStack.remove(MedSystemItemComponents.INTERACTION_TARGET);
    }

    protected final void cancelInteractionWithCooldown(ItemStack itemStack, LivingEntity entity) {
        entity.stopUsingItem();
        this.resetActiveInteraction(itemStack);
        InteractionHelper.addCooldown(entity, itemStack, 10);
    }

    private LivingEntity findInteractiveTarget(ItemStack itemStack, LivingEntity origin) {
        double range = 3.0;
        Vec3 eye = origin.getEyePosition();
        Vec3 look = origin.getViewVector(1.0f);
        Vec3 end = eye.add(look.x * range, look.y * range, look.z * range);
        AABB aabb = origin.getBoundingBox().expandTowards(look.scale(range)).inflate(1.0, 1.0, 1.0);
        EntityHitResult result = ProjectileUtil.getEntityHitResult((Entity)origin, (Vec3)eye, (Vec3)end, (AABB)aabb, (Predicate)EntitySelector.LIVING_ENTITY_STILL_ALIVE, (double)(range * range));
        LivingEntity entity = null;
        if (result != null) {
            result = InteractionHelper.filterHitResult((HitResult)result, eye, range);
        }
        if (result != null && result.getType() == HitResult.Type.ENTITY) {
            entity = (LivingEntity)result.getEntity();
        }
        if (entity != null && this.canUseItem(itemStack, entity, origin) && this.canInteractWithEntity(itemStack, entity, origin)) {
            return entity;
        }
        if (this.canUseItem(itemStack, origin, origin)) {
            return origin;
        }
        return null;
    }
}

