/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.client.screen.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import tnt.tarkovcraft.core.client.screen.listener.SimpleClickListener;
import tnt.tarkovcraft.core.util.helper.ARGB;
import tnt.tarkovcraft.core.util.helper.MathHelper;
import tnt.tarkovcraft.core.util.helper.RenderUtils;
import tnt.tarkovcraft.medsystem.client.MedicalSystemClient;
import tnt.tarkovcraft.medsystem.client.config.HealthOverlayConfiguration;
import tnt.tarkovcraft.medsystem.client.overlay.HealthLayer;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.effect.util.EffectVisibility;
import tnt.tarkovcraft.medsystem.common.health.Limb;

public class BodyPartHealthWidget
extends AbstractWidget {
    private final Screen parent;
    private final Font font;
    private final Limb part;
    private int frameSize = 1;
    private int frameColor = -1;
    private int frameHoverColor = -256;
    private int backgroundColor = -16777216;
    private int textColor = -1;
    private int textHoverColor = -256;
    private float healthScale = 1.0f;
    private int effectScale = 12;
    private SimpleClickListener onClick;
    private List<StatusEffect> effects;
    private boolean effectDetail = true;

    public BodyPartHealthWidget(int x, int y, int width, int height, Font font, Limb part, Screen parent) {
        super(x, y, width, height, CommonComponents.EMPTY);
        this.parent = parent;
        this.font = font;
        this.part = part;
    }

    public void setEffects(List<StatusEffect> effects) {
        this.effects = effects;
    }

    public void setEffectIconSize(int effectIconSize) {
        this.effectScale = effectIconSize;
    }

    public void setHealthUnitScale(float healthScale) {
        this.healthScale = healthScale;
    }

    public void setClickListener(SimpleClickListener onClick) {
        this.onClick = onClick;
    }

    public void setFrameSize(int frameSize) {
        this.frameSize = frameSize;
    }

    public void setFrameColor(int frameColor) {
        this.frameColor = frameColor;
    }

    public void setFrameHoverColor(int frameHoverColor) {
        this.frameHoverColor = frameHoverColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public void setTextHoverColor(int textHoverColor) {
        this.textHoverColor = textHoverColor;
    }

    public void setEffectDetail(boolean effectDetail) {
        this.effectDetail = effectDetail;
    }

    protected boolean isValidClickButton(int button) {
        return this.onClick != null;
    }

    public void onClick(double mouseX, double mouseY, int button) {
        this.onClick.onClick();
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.frameSize > 0 && RenderUtils.isVisibleColor((int)this.frameColor)) {
            int frameColor = this.isHovered ? this.frameHoverColor : this.frameColor;
            graphics.fill(this.getX(), this.getY(), this.getRight(), this.getBottom(), frameColor);
        }
        if (RenderUtils.isVisibleColor((int)this.backgroundColor)) {
            graphics.fill(this.getX() + this.frameSize, this.getY() + this.frameSize, this.getRight() - this.frameSize, this.getBottom() - this.frameSize, this.backgroundColor);
        }
        Component status = this.getStatusTitle();
        int statusWidth = this.font.width((FormattedText)status);
        int textColor = this.part.isDead() ? -65536 : (this.isHovered ? this.textHoverColor : this.textColor);
        graphics.drawString(this.font, status, this.getX() + (this.width - statusWidth) / 2, this.getY() + 3 + this.frameSize, textColor);
        HealthOverlayConfiguration overlay = MedicalSystemClient.getConfig().healthOverlay;
        int background = Integer.decode(overlay.deadLimbColor) | 0xFF000000;
        int secondaryBackground = ARGB.scaleRGB((int)background, (float)0.8f);
        int color = HealthLayer.getColor(overlay.deadLimbColor, overlay.colorSchema, this.part) | 0xFF000000;
        int secondaryColor = ARGB.scaleRGB((int)color, (float)0.8f);
        float f = this.part.getHealthPercent();
        graphics.fillGradient(this.getX() + this.frameSize + 1, this.getY() + this.frameSize + 13, this.getRight() - this.frameSize - 1, this.getY() + this.frameSize + 17, background, secondaryBackground);
        int left = this.getX() + this.frameSize + 2;
        int right = this.getRight() - this.frameSize - 2;
        graphics.fillGradient(left, this.getY() + this.frameSize + 14, left + (int)((float)(right - left) * f), this.getY() + this.frameSize + 16, color, secondaryColor);
        if (this.height >= 19 + this.effectScale + this.frameSize * 2 && this.effects != null && !this.effects.isEmpty()) {
            List<StatusEffect> visibleEffects = this.effects.stream().filter(effect -> StatusEffectType.isVisible(effect, EffectVisibility.UI)).toList();
            if (visibleEffects.isEmpty()) {
                return;
            }
            int bounds = this.width - this.frameSize - 2;
            int maxEffects = Math.min(visibleEffects.size(), bounds / this.effectScale);
            for (int i = 0; i < maxEffects; ++i) {
                StatusEffect effect2 = visibleEffects.get(i);
                StatusEffectType<?> type = effect2.getType();
                int effectX = this.getX() + this.frameSize + 1 + i * this.effectScale;
                int effectY = this.getBottom() - this.frameSize - 1 - this.effectScale;
                RenderUtils.blitFull((GuiGraphics)graphics, (ResourceLocation)type.getIcon(effect2), (int)effectX, (int)effectY, (int)(effectX + this.effectScale), (int)(effectY + this.effectScale));
                if (!this.effectDetail || !MathHelper.isWithinBounds((double)mouseX, (double)mouseY, (double)effectX, (double)effectY, (double)this.effectScale, (double)this.effectScale)) continue;
                ArrayList<Object> tooltip = new ArrayList<Object>();
                tooltip.add(type.getDisplayName(effect2).copy().withStyle((UnaryOperator)type.getEffectType()));
                effect2.addAdditionalInfo(tooltip::add);
                if (effect2.hasVisibleDuration() && !effect2.isInfinite()) {
                    tooltip.add(StatusEffect.getDurationLabel(effect2.getDuration()));
                }
                this.parent.setTooltipForNextRenderPass(RenderUtils.splitTooltip(tooltip, (Font)this.font));
            }
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    private Component getStatusTitle() {
        return this.isHovered ? this.part.getDisplayName() : Component.literal((String)(Mth.ceil((float)(this.part.getHealth() * this.healthScale)) + "/" + Mth.ceil((float)(this.part.getMaxHealth() * this.healthScale))));
    }
}

