/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health.math;

import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.List;
import java.util.Map;
import tnt.tarkovcraft.medsystem.common.health.DamageContext;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HitResult;
import tnt.tarkovcraft.medsystem.common.health.Limb;
import tnt.tarkovcraft.medsystem.common.health.math.DamageDistributor;

public class DecayingDamageDistributor
implements DamageDistributor {
    public static final DecayingDamageDistributor PROJECTILE = new DecayingDamageDistributor(0.5f);
    private final float decayFactor;

    public DecayingDamageDistributor(float decayFactor) {
        this.decayFactor = decayFactor;
    }

    @Override
    public Map<Limb, Float> distribute(DamageContext context, HealthContainer container, float damage) {
        List<HitResult> hits = context.getHits();
        if (hits.size() == 1) {
            return Map.of(hits.getFirst().limb(), Float.valueOf(damage));
        }
        Limb main = hits.getFirst().limb();
        Object2FloatOpenHashMap map = new Object2FloatOpenHashMap();
        for (int i = 0; i < hits.size(); ++i) {
            HitResult hit = hits.get(i);
            float partDamage = DecayingDamageDistributor.geometricDecay(damage, this.decayFactor, hits.size(), i);
            map.put((Object)hit.limb(), partDamage);
        }
        float damageSum = (float)map.values().doubleStream().sum();
        float extra = damage - damageSum;
        float mainDamage = map.getFloat((Object)main);
        map.put((Object)main, mainDamage + extra);
        return map;
    }

    public static float geometricDecay(float pool, float decayMult, int elements, int index) {
        float d = 1.0f - (float)Math.pow(decayMult, elements);
        float a = pool * (1.0f - decayMult) / d;
        return a * (float)Math.pow(decayMult, index);
    }
}

