/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health.math;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import tnt.tarkovcraft.medsystem.common.health.BodyPartHitbox;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HitResult;
import tnt.tarkovcraft.medsystem.common.health.Limb;
import tnt.tarkovcraft.medsystem.common.health.math.HitCalculator;

public class SpecificBodyPartHitCalculator
implements HitCalculator {
    private final String[] bodyParts;
    private final boolean allowDeadBodyParts;

    public SpecificBodyPartHitCalculator(String[] bodyParts, boolean allowDeadBodyParts) {
        this.bodyParts = bodyParts;
        this.allowDeadBodyParts = allowDeadBodyParts;
    }

    @Override
    public List<HitResult> calculateHits(LivingEntity entity, DamageSource source, HealthContainer container) {
        ArrayList<HitResult> hits = new ArrayList<HitResult>();
        for (String bodyPartId : this.bodyParts) {
            Limb part2;
            if (!container.hasLimb(bodyPartId) || (part2 = container.getLimb(bodyPartId)).isDead() && !this.allowDeadBodyParts) continue;
            HitResult result = new HitResult(null, container.getLimb(bodyPartId));
            hits.add(result);
        }
        if (hits.isEmpty()) {
            container.acceptHitboxes((hitbox, part) -> this.allowDeadBodyParts || !part.isDead(), (hitbox, part) -> hits.add(new HitResult((BodyPartHitbox)hitbox, (Limb)part)));
        }
        return hits;
    }
}

