/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import tnt.tarkovcraft.core.util.helper.TextHelper;

public record InteractionTarget(boolean self, int entityId, String limbCode) {
    public static final Codec<InteractionTarget> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("self", (Object)true).forGetter(InteractionTarget::self), (App)Codec.INT.optionalFieldOf("entityId", (Object)0).forGetter(InteractionTarget::entityId), (App)Codec.STRING.fieldOf("limb").forGetter(InteractionTarget::limbCode)).apply((Applicative)instance, InteractionTarget::new));
    public static final StreamCodec<ByteBuf, InteractionTarget> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, InteractionTarget::self, (StreamCodec)ByteBufCodecs.INT, InteractionTarget::entityId, (StreamCodec)ByteBufCodecs.STRING_UTF8, InteractionTarget::limbCode, InteractionTarget::new);

    public LivingEntity getTargetLivingEntity(LivingEntity healer) {
        Level level;
        Entity entity;
        if (!this.self && (entity = (level = healer.level()).getEntity(this.entityId)) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity;
        }
        return healer;
    }

    public static final class Mutable {
        private boolean self;
        private int entityId;
        private String limbCode;

        public Mutable(boolean self, int entityId, String limbCode) {
            this.self = self;
            this.entityId = entityId;
            this.limbCode = limbCode;
        }

        public boolean isSelf() {
            return this.self;
        }

        public void setSelf(boolean self) {
            this.self = self;
        }

        public int getEntityId() {
            return this.entityId;
        }

        public void setEntityId(int entityId) {
            this.entityId = entityId;
        }

        public String getLimbCode() {
            return this.limbCode;
        }

        public void setLimbCode(String limbCode) {
            this.limbCode = limbCode;
        }

        public boolean isLimbSelected() {
            return TextHelper.isNotBlank((String)this.limbCode);
        }

        public InteractionTarget toImmutable() {
            return new InteractionTarget(this.self, this.entityId, Objects.requireNonNull(this.limbCode));
        }
    }
}

