/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import tnt.tarkovcraft.core.util.Codecs;
import tnt.tarkovcraft.medsystem.common.health.BodyPartDefinition;
import tnt.tarkovcraft.medsystem.common.health.BodyPartDisplay;
import tnt.tarkovcraft.medsystem.common.health.BodyPartHitbox;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HealthContainerHelper;
import tnt.tarkovcraft.medsystem.common.health.HealthSystem;
import tnt.tarkovcraft.medsystem.common.init.MedSystemDataAttachments;

public final class HealthContainerDefinition {
    public static final Codec<HealthContainerDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("replace", (Object)false).forGetter(t -> t.replace), (App)Codecs.list((Codec)BuiltInRegistries.ENTITY_TYPE.byNameCodec()).optionalFieldOf("targets", Collections.emptyList()).forGetter(t -> t.targets), (App)Codec.unboundedMap((Codec)Codec.STRING, BodyPartDefinition.CODEC).optionalFieldOf("health", Collections.emptyMap()).forGetter(t -> t.bodyParts), (App)BodyPartHitbox.CODEC.listOf().optionalFieldOf("hitboxes", Collections.emptyList()).forGetter(t -> t.hitboxes), (App)BodyPartDisplay.CODEC.listOf().optionalFieldOf("hud", Collections.emptyList()).forGetter(t -> t.display)).apply((Applicative)instance, HealthContainerDefinition::new)).validate(HealthContainerHelper::validate);
    private final boolean replace;
    private final List<EntityType<?>> targets;
    private final Map<String, BodyPartDefinition> bodyParts;
    private final List<BodyPartHitbox> hitboxes;
    private final List<BodyPartDisplay> display;

    HealthContainerDefinition(boolean replace, List<EntityType<?>> targets, Map<String, BodyPartDefinition> bodyParts, List<BodyPartHitbox> hitboxes, List<BodyPartDisplay> display) {
        this.replace = replace;
        this.targets = targets;
        this.bodyParts = bodyParts;
        this.hitboxes = hitboxes;
        this.display = display;
    }

    public BodyPartDefinition getHealthTpl(String id) {
        return this.bodyParts.get(id);
    }

    public Map<String, BodyPartDefinition> getBodyParts() {
        return this.bodyParts;
    }

    public List<BodyPartHitbox> getHitboxes() {
        return this.hitboxes;
    }

    public void bind(LivingEntity entity) {
        HealthContainer data;
        HealthContainer healthContainer = data = HealthSystem.hasCustomHealth((Entity)entity) ? HealthSystem.getHealthData(entity) : null;
        if (data != null && !data.isInvalid()) {
            return;
        }
        if (data != null) {
            data.clearBoundData(entity);
        }
        float maxHealth = this.getMaxHealth();
        AttributeInstance instance = entity.getAttribute(Attributes.MAX_HEALTH);
        if (instance != null) {
            instance.setBaseValue((double)maxHealth);
        }
        HealthContainer container = new HealthContainer((IAttachmentHolder)entity);
        container.updateHealth(entity);
        entity.setData(MedSystemDataAttachments.HEALTH_CONTAINER, (Object)container);
    }

    public float getMaxHealth() {
        float value = 0.0f;
        for (BodyPartDefinition definition : this.bodyParts.values()) {
            value += definition.getMaxHealth();
        }
        return value;
    }

    public List<BodyPartDisplay> getDisplayConfiguration() {
        return this.display;
    }

    List<EntityType<?>> getTargets() {
        return this.targets;
    }

    public boolean canReplace() {
        return this.replace;
    }
}

