/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health.reaction;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import tnt.tarkovcraft.core.util.Codecs;
import tnt.tarkovcraft.medsystem.MedicalSystem;
import tnt.tarkovcraft.medsystem.common.config.MedSystemConfig;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.reaction.HealthEventSource;
import tnt.tarkovcraft.medsystem.common.health.reaction.HealthEventSourceType;
import tnt.tarkovcraft.medsystem.common.health.reaction.event.HealthSourceEvent;
import tnt.tarkovcraft.medsystem.common.health.reaction.event.HealthSourceEventType;

public record ReactionDefinition(HealthEventSource reaction, List<HealthSourceEvent> responses) {
    public static final Codec<ReactionDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)HealthEventSourceType.CODEC.fieldOf("source").forGetter(ReactionDefinition::reaction), (App)Codecs.list(HealthSourceEventType.CODEC).fieldOf("events").forGetter(ReactionDefinition::responses)).apply((Applicative)instance, ReactionDefinition::new));

    public void react(HealthContainer container, LivingEntity entity, @Nullable DamageSource source, BodyPart limb) {
        Player player;
        boolean noEffects;
        MedSystemConfig config = MedicalSystem.getConfig();
        boolean bl = noEffects = entity instanceof Player && ((player = (Player)entity).isCreative() || player.isSpectator());
        if (config.statusEffects.enableStatusEffects && this.reaction.canReact(container, entity, source, limb) && !noEffects) {
            this.responses.forEach(resp -> resp.onReactionPassed(this.reaction, container, entity, source, limb));
        }
    }
}

