/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.network.message;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import tnt.tarkovcraft.medsystem.MedicalSystem;
import tnt.tarkovcraft.medsystem.api.heal.HealItemAttributes;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HealthSystem;
import tnt.tarkovcraft.medsystem.common.init.MedSystemItemComponents;
import tnt.tarkovcraft.medsystem.common.item.InteractionTarget;
import tnt.tarkovcraft.medsystem.network.MedicalSystemNetwork;

public record C2S_SelectBodyPart(InteractionTarget target) implements CustomPacketPayload
{
    public static final ResourceLocation PACKET_ID = MedicalSystemNetwork.createId(C2S_SelectBodyPart.class);
    public static final CustomPacketPayload.Type<C2S_SelectBodyPart> TYPE = new CustomPacketPayload.Type(PACKET_ID);
    public static final StreamCodec<ByteBuf, C2S_SelectBodyPart> CODEC = StreamCodec.composite(InteractionTarget.STREAM_CODEC, C2S_SelectBodyPart::target, C2S_SelectBodyPart::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handleMessage(IPayloadContext context) {
        Player player = context.player();
        ItemStack stack = player.getMainHandItem();
        HealItemAttributes attributes = (HealItemAttributes)stack.get(MedSystemItemComponents.HEAL_ATTRIBUTES);
        LivingEntity targetEntity = this.getTargetEntity(player.level(), (LivingEntity)player);
        if (targetEntity == null) {
            MedicalSystem.LOGGER.warn(MedicalSystem.MARKER, "Could not find target entity for healing by entity ID");
            return;
        }
        if (!HealthSystem.hasCustomHealth((Entity)targetEntity)) {
            MedicalSystem.LOGGER.warn(MedicalSystem.MARKER, "Target entity \"{}\" does not have custom health container", (Object)targetEntity);
            return;
        }
        HealthContainer container = HealthSystem.getHealthData(targetEntity);
        BodyPart part = container.getBodyPart(this.target.limbCode());
        if (attributes != null && attributes.canUseOnPart(part, stack, container)) {
            stack.set(MedSystemItemComponents.INTERACTION_TARGET, (Object)this.target);
        }
    }

    private LivingEntity getTargetEntity(Level level, LivingEntity healer) {
        if (this.target.self()) {
            return healer;
        }
        int entityId = this.target.entityId();
        Entity entity = level.getEntity(entityId);
        if (entity instanceof LivingEntity) {
            LivingEntity targetEntity = (LivingEntity)entity;
            return targetEntity;
        }
        return null;
    }
}

