/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem;

import com.mojang.brigadier.CommandDispatcher;
import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.format.ConfigFormats;
import dev.toma.configuration.config.format.IConfigFormatHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddServerReloadListenersEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import tnt.tarkovcraft.medsystem.common.MedicalSystemEventHandler;
import tnt.tarkovcraft.medsystem.common.TarkovCraftCommand;
import tnt.tarkovcraft.medsystem.common.config.MedSystemConfig;
import tnt.tarkovcraft.medsystem.common.health.DefaultArmorComponent;
import tnt.tarkovcraft.medsystem.common.health.HealthSystem;
import tnt.tarkovcraft.medsystem.common.init.MedSystemAttributes;
import tnt.tarkovcraft.medsystem.common.init.MedSystemChanceFunctions;
import tnt.tarkovcraft.medsystem.common.init.MedSystemCreativeTabs;
import tnt.tarkovcraft.medsystem.common.init.MedSystemDataAttachments;
import tnt.tarkovcraft.medsystem.common.init.MedSystemHealthReactionResponses;
import tnt.tarkovcraft.medsystem.common.init.MedSystemHealthReactions;
import tnt.tarkovcraft.medsystem.common.init.MedSystemHitboxTransforms;
import tnt.tarkovcraft.medsystem.common.init.MedSystemItemComponents;
import tnt.tarkovcraft.medsystem.common.init.MedSystemItems;
import tnt.tarkovcraft.medsystem.common.init.MedSystemRegistries;
import tnt.tarkovcraft.medsystem.common.init.MedSystemSkillEvents;
import tnt.tarkovcraft.medsystem.common.init.MedSystemStats;
import tnt.tarkovcraft.medsystem.common.init.MedSystemStatusEffects;
import tnt.tarkovcraft.medsystem.common.init.MedSystemTransformConditions;
import tnt.tarkovcraft.medsystem.network.MedicalSystemNetwork;

@Mod(value="medsystem")
public final class MedicalSystem {
    public static final String MOD_ID = "medsystem";
    public static final Logger LOGGER = LogManager.getLogger((String)"TarkovCraftMedicalSystem");
    public static final Marker MARKER = MarkerManager.getMarker((String)"MedicalSystem");
    public static final HealthSystem HEALTH_SYSTEM = new HealthSystem();
    private static MedSystemConfig config;

    public MedicalSystem(IEventBus modEventBus, ModContainer container) {
        ConfigHolder holder = Configuration.registerConfig(MedSystemConfig.class, (IConfigFormatHandler)ConfigFormats.YAML);
        this.addCustomConfigValidations((ConfigHolder<MedSystemConfig>)holder);
        config = (MedSystemConfig)holder.getConfigInstance();
        modEventBus.addListener(this::createRegistries);
        modEventBus.register((Object)new MedicalSystemNetwork());
        NeoForge.EVENT_BUS.register((Object)new MedicalSystemEventHandler());
        NeoForge.EVENT_BUS.addListener(this::addReloadListeners);
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        MedSystemItems.REGISTRY.register(modEventBus);
        MedSystemDataAttachments.REGISTRY.register(modEventBus);
        MedSystemTransformConditions.REGISTRY.register(modEventBus);
        MedSystemHitboxTransforms.REGISTRY.register(modEventBus);
        MedSystemItemComponents.REGISTRY.register(modEventBus);
        MedSystemStats.REGISTRY.register(modEventBus);
        MedSystemSkillEvents.REGISTRY.register(modEventBus);
        MedSystemAttributes.REGISTRY.register(modEventBus);
        MedSystemStatusEffects.REGISTRY.register(modEventBus);
        MedSystemCreativeTabs.REGISTRY.register(modEventBus);
        MedSystemChanceFunctions.REGISTRY.register(modEventBus);
        MedSystemHealthReactionResponses.REGISTRY.register(modEventBus);
        MedSystemHealthReactions.REGISTRY.register(modEventBus);
    }

    public static MedSystemConfig getConfig() {
        return config;
    }

    private void createRegistries(NewRegistryEvent event) {
        event.register(MedSystemRegistries.TRANSFORM_CONDITION);
        event.register(MedSystemRegistries.TRANSFORM);
        event.register(MedSystemRegistries.STATUS_EFFECT);
        event.register(MedSystemRegistries.HEALTH_REACTION);
        event.register(MedSystemRegistries.HEALTH_REACTION_RESPONSE);
        event.register(MedSystemRegistries.CHANCE_FUNCTION);
    }

    private void addReloadListeners(AddServerReloadListenersEvent event) {
        event.addListener(HealthSystem.IDENTIFIER, (PreparableReloadListener)HEALTH_SYSTEM);
    }

    private void registerCommands(RegisterCommandsEvent event) {
        TarkovCraftCommand.create((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    public static ResourceLocation resource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    private void addCustomConfigValidations(ConfigHolder<MedSystemConfig> holder) {
        holder.getConfigValue("simpleArmorCalculation", Boolean.class).ifPresent(value -> value.addValidator(DefaultArmorComponent::checkInUse));
    }
}

