/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.api.heal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import tnt.tarkovcraft.core.common.attribute.AttributeSystem;
import tnt.tarkovcraft.core.common.data.duration.Duration;
import tnt.tarkovcraft.core.common.data.duration.DurationFormats;
import tnt.tarkovcraft.core.common.data.duration.DurationFormatter;
import tnt.tarkovcraft.medsystem.MedicalSystem;
import tnt.tarkovcraft.medsystem.common.effect.EffectType;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectMap;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.init.MedSystemAttributes;
import tnt.tarkovcraft.medsystem.common.init.MedSystemRegistries;

public record SideEffect(float chance, int duration, int delay, Holder<StatusEffectType<?>> effect) implements TooltipProvider
{
    public static final Codec<SideEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(t -> Float.valueOf(t.chance)), (App)Codec.INT.optionalFieldOf("duration", (Object)1200).forGetter(t -> t.duration), (App)Codec.INT.optionalFieldOf("delay", (Object)0).forGetter(t -> t.delay), (App)MedSystemRegistries.STATUS_EFFECT.holderByNameCodec().fieldOf("effect").forGetter(t -> t.effect)).apply((Applicative)instance, SideEffect::new));

    public void apply(LivingEntity entity, HealthContainer container, @Nullable BodyPart part) {
        this.applyFromDamage(entity, null, container, part);
    }

    public void applyFromDamage(LivingEntity entity, @Nullable DamageSource damageSource, HealthContainer container, @Nullable BodyPart part) {
        float effectChance;
        RandomSource source = entity.getRandom();
        StatusEffectType type = (StatusEffectType)this.effect.value();
        Holder chanceAttribute = type.getEffectType().byValue(MedSystemAttributes.POSITIVE_EFFECT_CHANCE, MedSystemAttributes.NEGATIVE_EFFECT_CHANCE, null);
        float f = effectChance = chanceAttribute != null ? this.chance * AttributeSystem.getFloatValue((Entity)entity, (Holder)chanceAttribute, (float)1.0f) : this.chance;
        if (source.nextFloat() < effectChance) {
            Object statusEffect;
            if (!type.isGlobalEffect() && part == null) {
                MedicalSystem.LOGGER.error(MedicalSystem.MARKER, "Failed to apply side effect {} as effect is not set as global, but target body part was not provided", this.effect);
                return;
            }
            Holder durationAttribute = type.getEffectType().byValue(MedSystemAttributes.POSITIVE_EFFECT_DURATION, MedSystemAttributes.NEGATIVE_EFFECT_DURATION, null);
            int duration = durationAttribute != null ? Mth.ceil((float)(AttributeSystem.getFloatValue((Entity)entity, (Holder)durationAttribute, (float)1.0f) * (float)this.duration)) : this.duration;
            StatusEffectMap effects = type.isGlobalEffect() ? container.getGlobalStatusEffects() : part.getStatusEffects();
            Object s = statusEffect = this.delay > 0 ? type.createDelayedEffect(duration, this.delay) : type.createImmediateEffect(duration);
            if (damageSource != null) {
                Entity cause;
                Entity entity2 = cause = damageSource.isDirect() ? damageSource.getDirectEntity() : damageSource.getEntity();
                if (cause != null) {
                    ((StatusEffect)statusEffect).setCausingEntity(cause.getUUID());
                }
            }
            effects.addEffect(statusEffect);
            if (this.delay > 0) {
                effects.addEffect(type.createDelayedEffect(duration, this.delay));
            } else {
                effects.addEffect(type.createImmediateEffect(duration));
            }
        }
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag flag, DataComponentGetter componentGetter) {
        StatusEffectType type = (StatusEffectType)this.effect.value();
        EffectType effectType = type.getEffectType();
        MutableComponent component = Component.literal((String)" - ");
        if (this.chance < 1.0f) {
            component.append(String.format(Locale.ROOT, "%.1f%%", Float.valueOf(this.chance * 100.0f)) + " ");
        }
        component.append(type.getDisplayName());
        if (this.duration > 0) {
            component.append(" / ").append((Component)Component.translatable((String)"tooltip.medsystem.heal_attributes.side_effects.duration", (Object[])new Object[]{Duration.format((int)this.duration, (DurationFormatter)DurationFormats.SHORT_NAME)}));
        }
        if (this.delay > 0) {
            component.append(" / ").append((Component)Component.translatable((String)"tooltip.medsystem.heal_attributes.side_effects.delay", (Object[])new Object[]{Duration.format((int)this.delay, (DurationFormatter)DurationFormats.SHORT_NAME)}));
        }
        tooltipAdder.accept((Component)component.withStyle((UnaryOperator)effectType));
    }
}

