/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.client.screen;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Vector2f;
import org.joml.Vector4f;
import tnt.tarkovcraft.core.client.screen.TooltipHelper;
import tnt.tarkovcraft.core.client.screen.renderable.AbstractTextRenderable;
import tnt.tarkovcraft.core.client.screen.renderable.ShapeRenderable;
import tnt.tarkovcraft.core.util.helper.TextHelper;
import tnt.tarkovcraft.medsystem.api.heal.HealItemAttributes;
import tnt.tarkovcraft.medsystem.client.screen.widget.BodyPartWidget;
import tnt.tarkovcraft.medsystem.common.effect.EffectVisibility;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;
import tnt.tarkovcraft.medsystem.common.health.BodyPartDisplay;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HealthContainerDefinition;
import tnt.tarkovcraft.medsystem.common.init.MedSystemDataAttachments;
import tnt.tarkovcraft.medsystem.common.init.MedSystemItemComponents;
import tnt.tarkovcraft.medsystem.network.message.C2S_SelectBodyPart;

public class SelectBodyPartScreen
extends Screen {
    public static final Component TITLE = TextHelper.createScreenTitle((String)"medsystem", (String)"select_body_part").withStyle(ChatFormatting.BOLD).withColor(0xE0E0E0);
    public static final Component LABEL_ERROR = TextHelper.createScreenComponent((String)"medsystem", (String)"select_body_part", (String)"error.invalid_item");
    public static final Component LABEL_NOT_HEALABLE = TextHelper.createScreenComponent((String)"medsystem", (String)"select_body_part", (String)"error.not_healable").withStyle(ChatFormatting.RED);
    public static final Component LABEL_CLICK_TO_SELECT = TextHelper.createScreenComponent((String)"medsystem", (String)"select_body_part", (String)"text.click_to_select").withStyle(ChatFormatting.GREEN);
    public static final Component LABEL_STATUS_EFFECTS = TextHelper.createScreenComponent((String)"medsystem", (String)"select_body_part", (String)"text.status_effects").withStyle(ChatFormatting.GRAY);

    public SelectBodyPartScreen() {
        super(TITLE);
    }

    protected void init() {
        ItemStack itemStack = this.minecraft.player.getMainHandItem();
        this.addRenderableOnly((Renderable)new ShapeRenderable(0, 0, this.width, this.height, -1157627904));
        this.addRenderableOnly((Renderable)new AbstractTextRenderable.CenteredComponent(0, 0, this.width, 30, -1, true, this.font, TITLE));
        if (itemStack.isEmpty()) {
            this.addError();
            return;
        }
        HealItemAttributes attributes = (HealItemAttributes)itemStack.get(MedSystemItemComponents.HEAL_ATTRIBUTES);
        if (attributes == null) {
            this.addError();
            return;
        }
        HealthContainer container = (HealthContainer)this.minecraft.player.getData(MedSystemDataAttachments.HEALTH_CONTAINER);
        HealthContainerDefinition definition = container.getDefinition();
        List<BodyPartDisplay> displays = definition.getDisplayConfiguration();
        Vector2f center = new Vector2f((float)this.width / 2.0f, (float)this.height / 2.0f);
        for (BodyPartDisplay display : displays) {
            BodyPart part = container.getBodyPart(display.source());
            Vector4f rect = display.getGuiPosition(2.0f, center);
            BodyPartWidget widget = (BodyPartWidget)this.addRenderableWidget((GuiEventListener)new BodyPartWidget((int)rect.x, (int)rect.y, (int)rect.z, (int)rect.w, part));
            boolean isPartHealable = attributes.canUseOnPart(part, itemStack, container);
            widget.setTooltipHelper(TooltipHelper.screen((Screen)this));
            widget.addTooltip((Component)part.getDisplayName().copy().withStyle(new ChatFormatting[]{ChatFormatting.BOLD, isPartHealable ? ChatFormatting.GREEN : ChatFormatting.RED}));
            List<Component> statusEffectLabels = part.getStatusEffects().getEffectsStream().filter(effect -> effect.getType().getVisibility().isVisibleInMode(EffectVisibility.UI)).map(effect -> Component.literal((String)"- ").append((Component)effect.getType().getDisplayName().copy()).withStyle(ChatFormatting.DARK_GRAY)).collect(Collectors.toList());
            if (!statusEffectLabels.isEmpty()) {
                widget.addTooltip(LABEL_STATUS_EFFECTS);
                statusEffectLabels.forEach(widget::addTooltip);
            }
            if (isPartHealable) {
                widget.setOnClick(() -> this.bodyPartClicked(part));
                widget.addTooltip(LABEL_CLICK_TO_SELECT);
                continue;
            }
            widget.addTooltip(LABEL_NOT_HEALABLE);
        }
    }

    private void bodyPartClicked(BodyPart part) {
        PacketDistributor.sendToServer((CustomPacketPayload)new C2S_SelectBodyPart(part.getName()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.minecraft.setScreen(null);
    }

    private void addError() {
        this.addRenderableOnly((Renderable)new AbstractTextRenderable.CenteredComponent(0, 0, this.width, this.height, -65536, true, this.font, LABEL_ERROR));
    }
}

