/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.client.screen.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.function.ToIntFunction;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import tnt.tarkovcraft.core.client.screen.SharedScreenState;
import tnt.tarkovcraft.core.client.screen.TooltipHelper;
import tnt.tarkovcraft.core.client.screen.listener.SimpleClickListener;
import tnt.tarkovcraft.medsystem.client.MedicalSystemClient;
import tnt.tarkovcraft.medsystem.client.config.HealthOverlayConfiguration;
import tnt.tarkovcraft.medsystem.client.overlay.HealthLayer;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;

public class BodyPartWidget
extends AbstractWidget {
    private final BodyPart part;
    private int scale = 2;
    private ToIntFunction<BodyPart> colorProvider;
    private SimpleClickListener onClick;
    private TooltipHelper tooltipHelper;
    private SharedScreenState<BodyPart> hoverState;
    private List<FormattedCharSequence> customTooltip = new ArrayList<FormattedCharSequence>();

    public BodyPartWidget(int x, int y, int width, int height, BodyPart part) {
        super(x, y, width, height, part.getDisplayName());
        this.part = part;
        this.colorProvider = bodypart -> {
            HealthOverlayConfiguration overlay = MedicalSystemClient.getConfig().healthOverlay;
            return HealthLayer.getColor(overlay.deadLimbColor, overlay.colorSchema, bodypart) | 0xFF000000;
        };
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int color = this.colorProvider.applyAsInt(this.part);
        if (this.hoverState != null) {
            if (this.isHovered) {
                this.hoverState.setState((Object)this, (Object)this.part);
            } else {
                this.hoverState.clearState((Object)this);
            }
            BodyPart statePart = (BodyPart)this.hoverState.getState();
            if (statePart != null && statePart.getName().equals(this.part.getName())) {
                color = ARGB.lerp((float)0.5f, (int)color, (int)-1);
            }
        }
        graphics.fill(this.getX(), this.getY(), this.getRight(), this.getBottom(), ARGB.scaleRGB((int)color, (float)0.8f));
        graphics.fill(this.getX() + this.scale, this.getY() + this.scale, this.getRight() - this.scale, this.getBottom() - this.scale, color);
        if (this.tooltipHelper != null && this.isHovered()) {
            this.tooltipHelper.setForNextRenderPass(this.customTooltip);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    protected boolean isValidClickButton(int button) {
        return this.onClick != null;
    }

    public void onClick(double mouseX, double mouseY, int button) {
        this.onClick.onClick();
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setColorProvider(ToIntFunction<BodyPart> colorProvider) {
        this.colorProvider = colorProvider;
    }

    public void setOnClick(SimpleClickListener onClick) {
        this.onClick = onClick;
    }

    public void setTooltipHelper(TooltipHelper tooltipHelper) {
        this.tooltipHelper = tooltipHelper;
    }

    public void setHoverState(SharedScreenState<BodyPart> hoverState) {
        this.hoverState = hoverState;
    }

    public TooltipHelper getTooltipHelper() {
        return this.tooltipHelper;
    }

    public void addTooltip(Component line) {
        if (this.tooltipHelper == null) {
            throw new UnsupportedOperationException("Tooltip helper is not set on widget!");
        }
        this.customTooltip.addAll(this.tooltipHelper.split(line));
    }
}

