/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.ArmorHurtEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import tnt.tarkovcraft.core.api.MovementStaminaComponent;
import tnt.tarkovcraft.core.api.event.StaminaEvent;
import tnt.tarkovcraft.core.common.attribute.AttributeSystem;
import tnt.tarkovcraft.core.common.energy.EnergySystem;
import tnt.tarkovcraft.core.common.skill.SkillSystem;
import tnt.tarkovcraft.core.common.statistic.StatisticTracker;
import tnt.tarkovcraft.medsystem.MedicalSystem;
import tnt.tarkovcraft.medsystem.api.ArmorComponent;
import tnt.tarkovcraft.medsystem.api.heal.SideEffectHolder;
import tnt.tarkovcraft.medsystem.api.heal.SideEffectProcessor;
import tnt.tarkovcraft.medsystem.common.config.MedSystemConfig;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;
import tnt.tarkovcraft.medsystem.common.health.BodyPartGroup;
import tnt.tarkovcraft.medsystem.common.health.DamageContext;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HealthSystem;
import tnt.tarkovcraft.medsystem.common.health.HitResult;
import tnt.tarkovcraft.medsystem.common.health.math.DamageDistributor;
import tnt.tarkovcraft.medsystem.common.health.math.HitCalculator;
import tnt.tarkovcraft.medsystem.common.init.MedSystemAttributes;
import tnt.tarkovcraft.medsystem.common.init.MedSystemDamageTypes;
import tnt.tarkovcraft.medsystem.common.init.MedSystemDataAttachments;
import tnt.tarkovcraft.medsystem.common.init.MedSystemItemComponents;
import tnt.tarkovcraft.medsystem.common.init.MedSystemSkillEvents;
import tnt.tarkovcraft.medsystem.common.init.MedSystemStats;

public final class MedicalSystemEventHandler {
    @SubscribeEvent
    private void onEntitySpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (event.isCanceled()) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            MedicalSystem.HEALTH_SYSTEM.getHealthContainer(livingEntity).ifPresent(container -> {
                container.bind(livingEntity);
                HealthSystem.synchronizeEntity(livingEntity);
            });
        }
    }

    @SubscribeEvent
    private void onLivingHeal(LivingHealEvent event) {
        LivingEntity entity = event.getEntity();
        float amount = event.getAmount();
        if (event.isCanceled()) {
            return;
        }
        if (amount > 0.0f && HealthSystem.hasCustomHealth((Entity)entity)) {
            float leftover = ((HealthContainer)entity.getData(MedSystemDataAttachments.HEALTH_CONTAINER)).heal(entity, amount, null);
            if (leftover > 0.0f) {
                event.setAmount(amount - leftover);
            }
            HealthSystem.synchronizeEntity(entity);
        }
    }

    @SubscribeEvent
    private void onInvulnerabilityCheck(EntityInvulnerabilityCheckEvent event) {
        if (event.isInvulnerable()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (!HealthSystem.hasCustomHealth((Entity)livingEntity)) {
            return;
        }
        HealthContainer container = (HealthContainer)entity.getData(MedSystemDataAttachments.HEALTH_CONTAINER);
        DamageSource source = event.getSource();
        HitCalculator hitCalculator = HealthSystem.getHitCalculator(livingEntity, source, container);
        List<HitResult> hits = hitCalculator.calculateHits(livingEntity, source, container);
        if (hits == null || hits.isEmpty()) {
            event.setInvulnerable(true);
        } else {
            DamageContext context = new DamageContext(livingEntity, source);
            context.setHits(hits);
            context.setHitCalculator(hitCalculator);
            context.setSideEffects(SideEffectHolder.fromDamage(source));
            container.setDamageContext(context);
        }
    }

    @SubscribeEvent
    private void onArmorHit(ArmorHurtEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        ArmorComponent component = (ArmorComponent)HealthSystem.ARMOR.getComponent();
        if (!HealthSystem.hasCustomHealth((Entity)entity) || component.useVanillaArmorDamage()) {
            return;
        }
        HealthContainer container = (HealthContainer)entity.getData(MedSystemDataAttachments.HEALTH_CONTAINER);
        DamageContext context = container.getDamageContext();
        HashSet<EquipmentSlot> hitSlots = new HashSet<EquipmentSlot>(context.getAffectedSlots());
        HashSet armorSlots = new HashSet(event.getArmorMap().keySet());
        Map map = event.getArmorMap();
        float damageReductionMultiplier = AttributeSystem.getFloatValue((Entity)entity, MedSystemAttributes.ARMOR_DURABILITY, (float)1.0f);
        for (EquipmentSlot slot : armorSlots) {
            if (!hitSlots.contains(slot)) {
                map.remove(slot);
                continue;
            }
            float damage = event.getNewDamage(slot).floatValue();
            if (!(damage > 0.0f) || damageReductionMultiplier == 1.0f) continue;
            event.setNewDamage(slot, Math.max(damage * damageReductionMultiplier, 1.0f));
        }
    }

    @SubscribeEvent
    private void onLivingDamage(LivingIncomingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        if (!HealthSystem.hasCustomHealth((Entity)entity)) {
            return;
        }
        HealthContainer container = (HealthContainer)entity.getData(MedSystemDataAttachments.HEALTH_CONTAINER);
        DamageContext context = container.getDamageContext();
        List<HitResult> hits = context.getHits();
        EnumSet<BodyPartGroup> hitGroups = EnumSet.noneOf(BodyPartGroup.class);
        for (HitResult hit : hits) {
            BodyPart bodyPart = hit.bodyPart();
            BodyPartGroup group2 = bodyPart.getGroup();
            hitGroups.add(group2);
        }
        ArmorComponent component = (ArmorComponent)HealthSystem.ARMOR.getComponent();
        EnumSet<BodyPartGroup> protectedGroups = EnumSet.noneOf(BodyPartGroup.class);
        component.collectAffectedBodyPartsWithProtection(protectedGroups::add, entity, context);
        protectedGroups.removeIf(group -> !hitGroups.contains(group));
        Set<EquipmentSlot> protectedSlots = protectedGroups.stream().flatMap(group -> group.getArmorSlots().stream()).collect(Collectors.toSet());
        context.setAffectedSlots(new ArrayList<EquipmentSlot>());
        float reduction = component.handleReductions(entity, context, protectedSlots, () -> ((LivingIncomingDamageEvent)event).getAmount(), arg_0 -> ((LivingIncomingDamageEvent)event).setAmount(arg_0), (arg_0, arg_1) -> ((LivingIncomingDamageEvent)event).addReductionModifier(arg_0, arg_1));
        if (reduction > 0.0f) {
            SkillSystem.triggerAndSynchronize(MedSystemSkillEvents.ARMOR_USE, (Entity)entity, (float)reduction);
        }
    }

    @SubscribeEvent
    private void onLivingApplyDamage(LivingDamageEvent.Post event) {
        float deathChance;
        LivingEntity entity = event.getEntity();
        if (!HealthSystem.hasCustomHealth((Entity)entity)) {
            return;
        }
        HealthContainer container = (HealthContainer)entity.getData(MedSystemDataAttachments.HEALTH_CONTAINER);
        DamageSource source = event.getSource();
        DamageContext context = container.getDamageContext();
        DamageDistributor damageDistributor = context.getDamageDistributor(container);
        Map<BodyPart, Float> distributedDamage = damageDistributor.distribute(context, container, event.getNewDamage());
        float totalDamage = distributedDamage.values().stream().reduce(Float.valueOf(0.0f), Float::sum).floatValue();
        ArrayList lostBodyParts = new ArrayList();
        SideEffectHolder sideEffects = context.getSideEffects();
        for (Map.Entry<BodyPart, Float> entry : distributedDamage.entrySet()) {
            container.hurt(context, entry.getValue().floatValue(), entry.getKey(), lostBodyParts::add);
            if (sideEffects == null) continue;
            sideEffects.applyFromDamage(entity, source, container, entry.getKey());
        }
        if (!source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            SkillSystem.triggerAndSynchronize(MedSystemSkillEvents.DAMAGE_TAKEN, (Entity)entity, (float)totalDamage);
        }
        container.clearDamageContext();
        container.updateHealth(entity);
        float f = deathChance = lostBodyParts.isEmpty() ? 0.0f : MedicalSystem.getConfig().limbLossDeathCauseChance;
        if (deathChance > 0.0f) {
            float deathChanceMultiplier = AttributeSystem.getFloatValue((Entity)entity, MedSystemAttributes.LIMB_DEATH_CHANCE, (float)1.0f);
            deathChance *= deathChanceMultiplier / (float)lostBodyParts.size();
        }
        HealthSystem.synchronizeEntity(entity);
        if (container.shouldDie() || deathChance > 0.0f && entity.getRandom().nextFloat() < deathChance) {
            entity.setHealth(0.0f);
        } else {
            MovementStaminaComponent component = (MovementStaminaComponent)EnergySystem.MOVEMENT_STAMINA.getComponent();
            if (entity.isSprinting() && !component.canSprint(entity)) {
                entity.setSprinting(false);
            }
        }
    }

    @SubscribeEvent
    private void canSprint(StaminaEvent.CanSprint event) {
        LivingEntity entity = event.getEntity();
        MedSystemConfig config = MedicalSystem.getConfig();
        if (config.enableHitEffects && HealthSystem.isMovementRestricted(entity) && !HealthSystem.hasPainRelief(entity)) {
            event.setCanSprint(Boolean.valueOf(false));
        }
    }

    @SubscribeEvent
    private void onSprinted(StaminaEvent.AfterSprint event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.level();
        MedSystemConfig config = MedicalSystem.getConfig();
        long gametime = level.getGameTime();
        if (config.enableHitEffects && gametime % 20L == 0L && HealthSystem.isMovementRestricted(entity)) {
            RegistryAccess access = entity.registryAccess();
            DamageSource source = new DamageSource(MedSystemDamageTypes.of(access, MedSystemDamageTypes.BROKEN_LEG));
            entity.hurt(source, 0.25f);
        }
    }

    @SubscribeEvent
    private void afterJump(StaminaEvent.AfterJump event) {
        LivingEntity entity = event.getEntity();
        MedSystemConfig config = MedicalSystem.getConfig();
        if (config.enableHitEffects && HealthSystem.isMovementRestricted(entity)) {
            RegistryAccess access = entity.registryAccess();
            DamageSource source = new DamageSource(MedSystemDamageTypes.of(access, MedSystemDamageTypes.BROKEN_LEG));
            entity.hurt(source, 0.5f);
        }
    }

    @SubscribeEvent
    private void onLivingDeath(LivingDeathEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        Entity killer = source.getEntity();
        if (HealthSystem.hasCustomHealth((Entity)entity)) {
            HealthContainer container = HealthSystem.getHealthData(entity);
            if (killer != null) {
                boolean headshot;
                boolean bl = headshot = source.is(DamageTypeTags.IS_PROJECTILE) && container.getBodyPartStream().anyMatch(part -> part.getGroup() == BodyPartGroup.HEAD && part.isDead());
                if (headshot) {
                    StatisticTracker.incrementOptional((IAttachmentHolder)killer, MedSystemStats.HEADSHOTS);
                    if (entity.getType() == EntityType.PLAYER) {
                        StatisticTracker.increment((IAttachmentHolder)killer, MedSystemStats.PLAYER_HEADSHOTS);
                    }
                }
            }
            container.invalidate();
        }
    }

    @SubscribeEvent
    private void addItemstackTooltips(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Item.TooltipContext context = event.getContext();
        List tooltip = event.getToolTip();
        TooltipFlag flag = event.getFlags();
        Consumer<Component> adder = tooltip::add;
        stack.addToTooltip(MedSystemItemComponents.HEAL_ATTRIBUTES, context, adder, flag);
        stack.addToTooltip(MedSystemItemComponents.SIDE_EFFECTS, context, adder, flag);
    }

    @SubscribeEvent
    private void onItemUseFinished(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack = event.getItem();
        LivingEntity entity = event.getEntity();
        if (!HealthSystem.hasCustomHealth((Entity)entity)) {
            return;
        }
        if (stack.has(MedSystemItemComponents.SIDE_EFFECTS) && !(stack.getItem() instanceof SideEffectProcessor)) {
            SideEffectHolder holder = (SideEffectHolder)stack.get(MedSystemItemComponents.SIDE_EFFECTS);
            HealthContainer container = HealthSystem.getHealthData(entity);
            String targetLimb = (String)stack.get(MedSystemItemComponents.SELECTED_BODY_PART);
            BodyPart part = container.getBodyPart(targetLimb);
            holder.apply(entity, container, part);
        }
    }
}

