/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import tnt.tarkovcraft.core.util.context.Context;
import tnt.tarkovcraft.core.util.context.ContextKeys;
import tnt.tarkovcraft.medsystem.common.effect.LightBleedStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.init.MedSystemStatusEffects;

public class FreshWoundStatusEffect
extends StatusEffect {
    public static final MapCodec<FreshWoundStatusEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> FreshWoundStatusEffect.common(instance).and((App)Codec.FLOAT.optionalFieldOf("bleedChance", (Object)Float.valueOf(0.0f)).forGetter(t -> Float.valueOf(t.bleedChance))).apply((Applicative)instance, FreshWoundStatusEffect::new));
    private float bleedChance;

    public FreshWoundStatusEffect(int duration, int delay) {
        this(duration, delay, 0.0f);
    }

    public FreshWoundStatusEffect(int duration, int delay, float bleedChance) {
        super(duration, delay);
        this.bleedChance = bleedChance;
    }

    @Override
    public void apply(Context context) {
        LivingEntity entity = (LivingEntity)context.getOrThrow(ContextKeys.LIVING_ENTITY);
        if (entity.isSprinting()) {
            this.bleedChance += 3.5E-4f;
            if (this.bleedChance >= 1.0f) {
                this.markForRemoval();
            }
        }
    }

    @Override
    public StatusEffect onRemoved(Context context) {
        LivingEntity entity = (LivingEntity)context.getOrThrow(ContextKeys.LIVING_ENTITY);
        RandomSource source = entity.getRandom();
        if (source.nextFloat() < this.bleedChance) {
            return new LightBleedStatusEffect(-1, 0);
        }
        return null;
    }

    @Override
    public StatusEffect copy() {
        return new FreshWoundStatusEffect(this.getDuration(), this.getDelay(), this.bleedChance);
    }

    @Override
    public void addAdditionalInfo(Consumer<Component> tooltip) {
        tooltip.accept((Component)Component.translatable((String)"status_effect.medsystem.fresh_wound.info").withStyle(ChatFormatting.DARK_GRAY));
    }

    @Override
    public StatusEffectType<?> getType() {
        return (StatusEffectType)MedSystemStatusEffects.FRESH_WOUND.value();
    }
}

