/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.effect;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import tnt.tarkovcraft.core.common.data.duration.Duration;
import tnt.tarkovcraft.core.util.context.Context;
import tnt.tarkovcraft.medsystem.common.effect.BleedStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.FreshWoundStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.init.MedSystemStatusEffects;

public class HeavyBleedStatusEffect
extends BleedStatusEffect {
    public static final MapCodec<HeavyBleedStatusEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> HeavyBleedStatusEffect.commonEntity(instance).apply((Applicative)instance, HeavyBleedStatusEffect::new));

    public HeavyBleedStatusEffect(int duration, int delay, Optional<UUID> owner) {
        super(duration, delay, owner);
    }

    public HeavyBleedStatusEffect(int duration, int delay) {
        super(duration, delay);
    }

    @Override
    public long getDamageInterval() {
        return 30L;
    }

    @Override
    public float getDamageAmount() {
        return 0.75f;
    }

    @Override
    public StatusEffect copy() {
        return new HeavyBleedStatusEffect(this.getDuration(), this.getDelay());
    }

    @Override
    public StatusEffect onRemoved(Context context) {
        return new FreshWoundStatusEffect(Duration.minutes((int)5).tickValue(), Duration.seconds((int)5).tickValue());
    }

    @Override
    public void addAdditionalInfo(Consumer<Component> tooltip) {
        tooltip.accept((Component)Component.translatable((String)"status_effect.medsystem.heavy_bleed.heal_hint").withStyle(ChatFormatting.DARK_GRAY));
    }

    @Override
    public StatusEffectType<?> getType() {
        return (StatusEffectType)MedSystemStatusEffects.HEAVY_BLEED.value();
    }
}

