/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.effect;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import tnt.tarkovcraft.core.common.attribute.Attribute;
import tnt.tarkovcraft.core.common.attribute.EntityAttributeData;
import tnt.tarkovcraft.core.common.attribute.modifier.AddValueModifier;
import tnt.tarkovcraft.core.common.attribute.modifier.AttributeModifier;
import tnt.tarkovcraft.core.util.context.Context;
import tnt.tarkovcraft.medsystem.common.effect.AttributeModifyingStatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.init.MedSystemAttributes;
import tnt.tarkovcraft.medsystem.common.init.MedSystemStatusEffects;

public class PainReliefEffect
extends AttributeModifyingStatusEffect {
    public static final MapCodec<PainReliefEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> PainReliefEffect.common(instance).apply((Applicative)instance, PainReliefEffect::new));
    public static final UUID PAIN_RELIEF_MODIFIER_ID = UUID.fromString("03d3708f-37bf-42a9-8599-b8af97cc7b4f");

    public PainReliefEffect(int duration, int delay) {
        super(duration, delay);
    }

    @Override
    public UUID getUniqueModifierUUID() {
        return PAIN_RELIEF_MODIFIER_ID;
    }

    @Override
    public Holder<Attribute> getAttribute() {
        return MedSystemAttributes.PAIN_RELIEF;
    }

    @Override
    public AttributeModifier createModifier(UUID uuid, LivingEntity entity, EntityAttributeData attributeData, Context context) {
        return new AddValueModifier(uuid, 1.0);
    }

    @Override
    public StatusEffect copy() {
        return new PainReliefEffect(this.getDuration(), this.getDelay());
    }

    @Override
    public StatusEffectType<?> getType() {
        return (StatusEffectType)MedSystemStatusEffects.PAIN_RELIEF.value();
    }
}

