/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import tnt.tarkovcraft.medsystem.MedicalSystem;
import tnt.tarkovcraft.medsystem.common.health.BodyPartDefinition;
import tnt.tarkovcraft.medsystem.common.health.BodyPartDisplay;
import tnt.tarkovcraft.medsystem.common.health.BodyPartGroup;
import tnt.tarkovcraft.medsystem.common.health.BodyPartHitbox;
import tnt.tarkovcraft.medsystem.common.health.HealthContainerDefinition;
import tnt.tarkovcraft.medsystem.common.health.HealthSystem;
import tnt.tarkovcraft.medsystem.common.health.reaction.ReactionDefinition;

public final class HealthContainerHelper {
    public static DataResult<HealthContainerDefinition> validate(HealthContainerDefinition container) {
        Set hitboxOwners = container.getHitboxes().stream().map(BodyPartHitbox::getOwner).collect(Collectors.toSet());
        if (container.getBodyParts().isEmpty()) {
            return DataResult.error(() -> "At least one body part must be specified");
        }
        if (hitboxOwners.size() != container.getBodyParts().size()) {
            return DataResult.error(() -> "Mismatched hitbox count. Got " + hitboxOwners.size() + ", expected " + container.getBodyParts().size());
        }
        for (String owner : container.getBodyParts().keySet()) {
            if (hitboxOwners.contains(owner)) continue;
            return DataResult.error(() -> "Missing hitbox definition for body part " + owner);
        }
        DataResult<String> rootValidation = HealthContainerHelper.getRootBodyPart(container.getBodyParts());
        if (rootValidation.isError()) {
            return rootValidation.map(s -> container);
        }
        String root = (String)rootValidation.getOrThrow();
        for (Map.Entry<String, BodyPartDefinition> entry : container.getBodyParts().entrySet()) {
            String error = HealthContainerHelper.validateBodyPartLink(root, entry.getKey(), entry.getValue(), container.getBodyParts());
            if (error == null) continue;
            return DataResult.error(() -> "Validation of body part links of " + (String)entry.getKey() + " part failed: " + error);
        }
        Set displaySources = container.getDisplayConfiguration().stream().map(BodyPartDisplay::source).collect(Collectors.toSet());
        for (String source : displaySources) {
            if (container.getBodyParts().containsKey(source)) continue;
            return DataResult.error(() -> "Missing body part for source " + source);
        }
        return DataResult.success((Object)container);
    }

    private static String validateBodyPartLink(String root, String partId, BodyPartDefinition part, Map<String, BodyPartDefinition> bodyParts) {
        String parent;
        if (partId.equals(root)) {
            return null;
        }
        HashSet<String> previousParents = new HashSet<String>();
        do {
            if (!bodyParts.containsKey(parent = part.getParent())) {
                return "Unknown body part in link: " + parent;
            }
            if (!previousParents.add(parent)) {
                return "Circular reference in body part links: " + parent;
            }
            part = bodyParts.get(parent);
        } while (!parent.equals(root));
        return null;
    }

    private static DataResult<String> getRootBodyPart(Map<String, BodyPartDefinition> parts) {
        String root = null;
        for (Map.Entry<String, BodyPartDefinition> entry : parts.entrySet()) {
            BodyPartDefinition part = entry.getValue();
            if (part.getParent() != null) continue;
            if (root != null) {
                return DataResult.error(() -> "Multiple root body parts detected");
            }
            root = entry.getKey();
        }
        return root != null ? DataResult.success(root) : DataResult.error(() -> "Missing root body part");
    }

    public static HealthContainerDefinition merge(EntityType<?> type, HealthContainerDefinition self, HealthContainerDefinition other) {
        MedicalSystem.LOGGER.warn(HealthSystem.MARKER, "Merging multiple health container definitions for entity '{}'", (Object)BuiltInRegistries.ENTITY_TYPE.getKey(type));
        if (other.canReplace()) {
            return other;
        }
        List<EntityType<?>> targets = HealthContainerHelper.mergeTargets(self, other);
        Pair<Map<String, BodyPartDefinition>, Set<String>> bodyPartMerge = HealthContainerHelper.mergeAndRemoveBodyParts(self, other);
        Map newBodyParts = (Map)bodyPartMerge.getFirst();
        Set deletedParts = (Set)bodyPartMerge.getSecond();
        List<BodyPartHitbox> hitboxes = HealthContainerHelper.mergeHitboxes(self, other, deletedParts);
        List<BodyPartDisplay> displays = HealthContainerHelper.mergeDisplays(self, other, deletedParts);
        return (HealthContainerDefinition)HealthContainerHelper.validate(new HealthContainerDefinition(self.canReplace(), targets, newBodyParts, hitboxes, displays)).getOrThrow();
    }

    private static List<EntityType<?>> mergeTargets(HealthContainerDefinition self, HealthContainerDefinition other) {
        ArrayList targets = new ArrayList(self.getTargets());
        targets.addAll(other.getTargets());
        return targets;
    }

    private static Pair<Map<String, BodyPartDefinition>, Set<String>> mergeAndRemoveBodyParts(HealthContainerDefinition self, HealthContainerDefinition other) {
        HashSet<String> deletedParts = new HashSet<String>();
        HashMap<String, BodyPartDefinition> newBodyParts = new HashMap<String, BodyPartDefinition>(self.getBodyParts());
        for (Map.Entry<String, BodyPartDefinition> entry : other.getBodyParts().entrySet()) {
            BodyPartGroup group = entry.getValue().getBodyPartGroup();
            if (group.isInactive()) {
                newBodyParts.remove(entry.getKey());
                deletedParts.add(entry.getKey());
                continue;
            }
            BodyPartDefinition def1 = (BodyPartDefinition)newBodyParts.get(entry.getKey());
            BodyPartDefinition def2 = entry.getValue();
            if (def1 == null) {
                newBodyParts.put(entry.getKey(), def2);
                continue;
            }
            newBodyParts.put(entry.getKey(), HealthContainerHelper.mergeBodyPart(def1, def2));
        }
        return Pair.of(newBodyParts, deletedParts);
    }

    public static BodyPartDefinition mergeBodyPart(BodyPartDefinition self, BodyPartDefinition other) {
        boolean vital = other.isVital();
        String parent = other.getParent();
        float parentDamageScale = other.getParentDamageScale();
        float damageScale = other.getDamageScale();
        float health = other.getMaxHealth();
        BodyPartGroup group = other.getBodyPartGroup();
        Map<UUID, ReactionDefinition> reactions = HealthContainerHelper.mergeReactions(self, other);
        return new BodyPartDefinition(vital, Optional.ofNullable(parent), parentDamageScale, damageScale, health, group, reactions);
    }

    private static Map<UUID, ReactionDefinition> mergeReactions(BodyPartDefinition self, BodyPartDefinition other) {
        HashMap<UUID, ReactionDefinition> map = new HashMap<UUID, ReactionDefinition>(self.getReactionMap());
        map.putAll(other.getReactionMap());
        return map;
    }

    private static List<BodyPartHitbox> mergeHitboxes(HealthContainerDefinition self, HealthContainerDefinition other, Set<String> deletedParts) {
        ArrayList<BodyPartHitbox> hitboxes = new ArrayList<BodyPartHitbox>(self.getHitboxes());
        hitboxes.addAll(other.getHitboxes());
        hitboxes.removeIf(t -> deletedParts.contains(t.getOwner()));
        return hitboxes;
    }

    private static List<BodyPartDisplay> mergeDisplays(HealthContainerDefinition self, HealthContainerDefinition other, Set<String> deletedParts) {
        ArrayList<BodyPartDisplay> display = new ArrayList<BodyPartDisplay>(self.getDisplayConfiguration());
        display.addAll(other.getDisplayConfiguration());
        display.removeIf(t -> deletedParts.contains(t.source()));
        return display;
    }
}

