/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health.math;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;
import tnt.tarkovcraft.medsystem.common.health.BodyPartHitbox;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HealthSystem;
import tnt.tarkovcraft.medsystem.common.health.HitResult;
import tnt.tarkovcraft.medsystem.common.health.PositionedAABB;
import tnt.tarkovcraft.medsystem.common.health.math.HitCalculator;

public class MeleeHitCalculator
implements HitCalculator {
    public static final MeleeHitCalculator INSTANCE = new MeleeHitCalculator();

    @Override
    public List<HitResult> calculateHits(LivingEntity entity, DamageSource source, HealthContainer container) {
        ArrayList<HitResult> hits = new ArrayList<HitResult>();
        Entity attacker = source.getEntity();
        Vec3 from = attacker.getType() == EntityType.PLAYER ? attacker.getEyePosition() : new Vec3(attacker.getX(), attacker.getY() + (double)attacker.getBbHeight() / 2.0, attacker.getZ());
        Vec3 to = from.add(attacker.getLookAngle().scale(5.0));
        container.acceptHitboxes((hitbox, part) -> {
            AABB aabb = hitbox.getLevelPositionedAABB(entity);
            PositionedAABB.tryIntersect(aabb, from, to).ifPresent(hit -> hits.add(new HitResult((BodyPartHitbox)hitbox, (BodyPart)part, aabb, (Vec3)hit)));
        });
        if (!hits.isEmpty()) {
            hits.sort(Comparator.comparingDouble(res -> res.aabb().distanceToSqr(from)));
            return Collections.singletonList((HitResult)hits.getFirst());
        }
        List<HitResult> result = HealthSystem.getClosestPossibleHits(attacker.getBoundingBox().getCenter(), entity, container, (hitbox, part) -> !part.isDead());
        return result.isEmpty() ? Collections.emptyList() : Collections.singletonList(result.getFirst());
    }
}

