/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public final class InteractionHelper {
    public static HitResult filterHitResult(HitResult hitResult, Vec3 pos, double blockInteractionRange) {
        Vec3 vec3 = hitResult.getLocation();
        if (!vec3.closerThan((Position)pos, blockInteractionRange)) {
            Vec3 vec31 = hitResult.getLocation();
            Direction direction = InteractionHelper.getApproximateNearest(vec31.x - pos.x, vec31.y - pos.y, vec31.z - pos.z);
            return BlockHitResult.miss((Vec3)vec31, (Direction)direction, (BlockPos)BlockPos.containing((Position)vec31));
        }
        return hitResult;
    }

    public static boolean hasCooldown(LivingEntity entity, ItemStack itemStack) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemCooldowns cooldowns = player.getCooldowns();
            return cooldowns.isOnCooldown(itemStack.getItem());
        }
        return false;
    }

    public static void addCooldown(LivingEntity entity, ItemStack itemStack, int cooldownTicks) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemCooldowns cooldowns = player.getCooldowns();
            cooldowns.addCooldown(itemStack.getItem(), cooldownTicks);
        }
    }

    public static Direction getApproximateNearest(double x, double y, double z) {
        Direction direction = Direction.NORTH;
        double f = 1.4E-45f;
        for (Direction direction1 : Direction.values()) {
            double f1 = x * (double)direction1.getNormal().getX() + y * (double)direction1.getNormal().getY() + z * (double)direction1.getNormal().getZ();
            if (!(f1 > f)) continue;
            f = f1;
            direction = direction1;
        }
        return direction;
    }
}

