/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import tnt.tarkovcraft.medsystem.MedicalSystem;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.effect.util.StatusEffectSubmitter;
import tnt.tarkovcraft.medsystem.common.health.BodyPart;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HealthSystem;
import tnt.tarkovcraft.medsystem.common.init.MedSystemStatusEffects;

public class InjuryRecoveryStatusEffect
extends StatusEffect {
    public static final MapCodec<InjuryRecoveryStatusEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> InjuryRecoveryStatusEffect.common(instance).and((App)Codec.INT.fieldOf("reduction").forGetter(t -> t.reduction)).apply((Applicative)instance, InjuryRecoveryStatusEffect::new));
    private static final Component INFO = Component.translatable((String)"status_effect.medsystem.injury_recovery.info").withStyle(ChatFormatting.DARK_GRAY);
    private int reduction;

    public InjuryRecoveryStatusEffect(int duration) {
        this(duration, 1);
    }

    public InjuryRecoveryStatusEffect(int duration, int reduction) {
        super(duration);
        this.reduction = reduction;
    }

    public static InjuryRecoveryStatusEffect createTemplate(int reduction) {
        return new InjuryRecoveryStatusEffect(-1, reduction);
    }

    @Override
    public void apply(HealthContainer container, LivingEntity entity, @Nullable BodyPart limb) {
        ResourceLocation modifierId;
        if (this.reduction < 1 || limb == null) {
            this.markForRemoval();
            return;
        }
        this.reduction = Math.min((int)limb.getMaxHealth() - 1, this.reduction);
        AttributeMap map = entity.getAttributes();
        AttributeInstance instance = map.getInstance(Attributes.MAX_HEALTH);
        AttributeModifier modifier = instance.getModifier(modifierId = this.getUniqueModifierId(limb));
        if (modifier == null || modifier.amount() != (double)(-this.reduction)) {
            float newMaxHealth = limb.getMaxHealth() - (float)this.reduction;
            instance.addOrReplacePermanentModifier(new AttributeModifier(modifierId, (double)(-this.reduction), AttributeModifier.Operation.ADD_VALUE));
            limb.setMaxHealth(newMaxHealth);
            container.updateHealth(entity);
            HealthSystem.synchronizeEntity(entity);
        }
    }

    @Override
    public void onRemoved(StatusEffectSubmitter submitter, HealthContainer container, LivingEntity entity, @Nullable BodyPart limb) {
        if (limb != null) {
            limb.setMaxHealth(limb.getMaxHealth() + (float)this.reduction);
            AttributeMap map = entity.getAttributes();
            AttributeInstance instance = map.getInstance(Attributes.MAX_HEALTH);
            instance.removeModifier(this.getUniqueModifierId(limb));
            container.updateHealth(entity);
            HealthSystem.synchronizeEntity(entity);
        }
    }

    public void setReduction(int reduction) {
        this.reduction = reduction;
    }

    @Override
    public StatusEffect copy() {
        return new InjuryRecoveryStatusEffect(this.getDuration(), this.reduction);
    }

    @Override
    public void addAdditionalInfo(Consumer<Component> tooltip) {
        tooltip.accept(INFO);
    }

    @Override
    public StatusEffectType<?> getType() {
        return (StatusEffectType)MedSystemStatusEffects.INJURY_RECOVERY.value();
    }

    private ResourceLocation getUniqueModifierId(BodyPart part) {
        return MedicalSystem.resource("health_reduction/" + part.getName().toLowerCase(Locale.ROOT));
    }

    public static InjuryRecoveryStatusEffect merge(InjuryRecoveryStatusEffect initial, InjuryRecoveryStatusEffect additional) {
        boolean allowScaling = MedicalSystem.getConfig().allowInjuryRecoveryScaling;
        if (allowScaling) {
            return new InjuryRecoveryStatusEffect(initial.getDuration() + additional.getDuration(), initial.reduction + additional.reduction);
        }
        return new InjuryRecoveryStatusEffect(Math.max(initial.getDuration(), additional.getDuration()), initial.reduction);
    }
}

