/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.world.entity.EquipmentSlot;

public enum BodyPartGroup {
    HEAD(0, 0xFF0000, EquipmentSlot.HEAD, new EquipmentSlot[0]),
    TORSO(0, 0xFFFF00, EquipmentSlot.CHEST, new EquipmentSlot[0]),
    STOMACH(20, 65280, EquipmentSlot.CHEST, new EquipmentSlot[0]),
    ARM(10, 65535),
    LEG(30, 255, EquipmentSlot.LEGS, EquipmentSlot.FEET),
    ANIMAL(0, 65280, EquipmentSlot.BODY, new EquipmentSlot[0]),
    OTHER(0, 0x444444);

    private final int surgeryPriority;
    private final int hitboxColor;
    private final Set<EquipmentSlot> armorSlots;

    private BodyPartGroup(int surgeryPriority, int hitboxColor) {
        this(surgeryPriority, hitboxColor, null, new EquipmentSlot[0]);
    }

    private BodyPartGroup(int surgeryPriority, int hitboxColor, EquipmentSlot first, EquipmentSlot ... other) {
        this.surgeryPriority = surgeryPriority;
        this.hitboxColor = hitboxColor;
        this.armorSlots = first != null ? EnumSet.of(first, other) : Collections.emptySet();
    }

    public static EnumSet<BodyPartGroup> getProtectedByEquipment(EquipmentSlot slot) {
        EnumSet<BodyPartGroup> set = EnumSet.noneOf(BodyPartGroup.class);
        for (BodyPartGroup group : BodyPartGroup.values()) {
            if (!group.armorSlots.contains(slot)) continue;
            set.add(group);
        }
        return set;
    }

    public Set<EquipmentSlot> getArmorSlots() {
        return this.armorSlots;
    }

    public int getHitboxColor() {
        return this.hitboxColor;
    }

    public int getSurgeryHealingPriority() {
        return this.surgeryPriority;
    }
}

