/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.status;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.status.BloodData;

public enum BloodStatus {
    DEATH(0.25f, BloodData::onDeathBloodLevel),
    UNCONSCIOUS(0.4f, BloodData::onUnconsciousBloodLevel),
    RANDOM_BLACKOUT(0.65f, BloodData::onRandomBlackoutBloodLevel),
    MODERATE_BLOOD_LOSS(0.8f, BloodData::onModerateBloodLoss),
    MILD_BLOOD_LOSS(0.9f, BloodData::onMildBloodLoss),
    HEALTHY(1.0f, BloodData::onClearDebuffData);

    private final float percentage;
    private final DebuffEffect effect;

    private BloodStatus(float percentage, DebuffEffect effect) {
        this.percentage = percentage;
        this.effect = effect;
    }

    public boolean isInRange(float percentage) {
        return percentage < this.percentage;
    }

    public boolean isLowBloodLevel() {
        return this != HEALTHY;
    }

    public boolean isSameOrAbove(BloodStatus status) {
        return this.ordinal() >= status.ordinal();
    }

    public boolean isSameOrBelow(BloodStatus status) {
        return this.ordinal() <= status.ordinal();
    }

    public void applyEffects(BloodData bloodData, LivingEntity entity, ServerLevel level, HealthContainer container) {
        this.effect.apply(bloodData, entity, level, container);
    }

    public static BloodStatus fromBloodLevelPercentage(float percentage) {
        for (BloodStatus bloodStatus : BloodStatus.values()) {
            if (!bloodStatus.isInRange(percentage)) continue;
            return bloodStatus;
        }
        return HEALTHY;
    }

    @FunctionalInterface
    public static interface DebuffEffect {
        public void apply(BloodData var1, LivingEntity var2, ServerLevel var3, HealthContainer var4);
    }
}

