/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.status;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import tnt.tarkovcraft.medsystem.MedicalSystem;
import tnt.tarkovcraft.medsystem.api.event.BloodEvent;
import tnt.tarkovcraft.medsystem.common.config.MedSystemConfig;
import tnt.tarkovcraft.medsystem.common.init.MedSystemDataAttachments;
import tnt.tarkovcraft.medsystem.common.status.BloodData;
import tnt.tarkovcraft.medsystem.common.status.BloodStatus;

public final class BloodSystem {
    public static boolean isEnabled() {
        MedSystemConfig config = MedicalSystem.getConfig();
        return config.useBloodSystem;
    }

    public static boolean hasBloodDataIntegration(LivingEntity entity) {
        return BloodSystem.isEnabled() && entity.hasData(MedSystemDataAttachments.BLOOD_DATA);
    }

    public static void causeBloodLoss(LivingEntity entity, float amount) {
        if (!BloodSystem.isEnabled() && !BloodSystem.hasBloodDataIntegration(entity)) {
            return;
        }
        BloodData data = BloodSystem.getBloodData(entity);
        BloodEvent.BloodLossEvent.Pre event = (BloodEvent.BloodLossEvent.Pre)NeoForge.EVENT_BUS.post((Event)new BloodEvent.BloodLossEvent.Pre(entity, data, amount));
        float eventAmount = event.getAmount();
        if (eventAmount > 0.0f) {
            float newVolume = data.getBloodVolume() - eventAmount;
            data.setBloodVolume(newVolume);
            NeoForge.EVENT_BUS.post((Event)new BloodEvent.BloodLossEvent.Post(entity, data, amount, eventAmount));
            data.updateEffects(entity);
            data.sync(entity);
        }
    }

    public static BloodData getBloodData(LivingEntity entity) {
        return (BloodData)entity.getData(MedSystemDataAttachments.BLOOD_DATA);
    }

    public static boolean isEntityUnconscious(LivingEntity entity) {
        return entity.isAlive() && BloodSystem.hasBloodDataIntegration(entity) && BloodSystem.getBloodData(entity).isUnconscious();
    }

    public static boolean canGiveUp(Player player) {
        if (player == null) {
            return false;
        }
        BloodData bloodData = BloodSystem.getBloodData((LivingEntity)player);
        if (bloodData.isUnconscious()) {
            BloodData.UnconsciousInfo info = bloodData.getUnconsciousInfo();
            float percentage = bloodData.getBloodVolumePercentage();
            BloodStatus status = BloodStatus.fromBloodLevelPercentage(percentage);
            return info.showGiveUpHint() && status != BloodStatus.DEATH;
        }
        return false;
    }
}

