/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.effect.group;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import tnt.tarkovcraft.medsystem.api.heal.SideEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.group.EffectGroupHolder;
import tnt.tarkovcraft.medsystem.common.effect.group.EffectGroupItem;
import tnt.tarkovcraft.medsystem.common.effect.group.EffectGroupItemType;
import tnt.tarkovcraft.medsystem.common.effect.util.EffectType;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.Limb;
import tnt.tarkovcraft.medsystem.common.init.MedSystemDamageTypes;
import tnt.tarkovcraft.medsystem.common.init.MedSystemStatusEffectGroupItems;

public class HealthEffectGroupItem
implements EffectGroupItem {
    public static final MapCodec<HealthEffectGroupItem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("effectId").forGetter(t -> t.effectId), (App)Codec.FLOAT.fieldOf("amount").forGetter(t -> Float.valueOf(t.amount)), (App)Codec.INT.fieldOf("interval").forGetter(t -> t.interval)).apply((Applicative)instance, HealthEffectGroupItem::new));
    private final UUID effectId;
    private final float amount;
    private final int interval;

    public HealthEffectGroupItem(String uuid, float amount) {
        this(UUID.fromString(uuid), amount);
    }

    public HealthEffectGroupItem(UUID effectId, float amount) {
        this(effectId, amount, 20);
    }

    public HealthEffectGroupItem(String uuid, float amount, int interval) {
        this(UUID.fromString(uuid), amount, interval);
    }

    public HealthEffectGroupItem(UUID effectId, float amount, int interval) {
        this.effectId = effectId;
        this.amount = amount;
        this.interval = interval;
    }

    @Override
    public void init(EffectGroupHolder holder, HealthContainer container, LivingEntity entity, @Nullable Limb limb) {
    }

    @Override
    public void apply(EffectGroupHolder holder, HealthContainer container, LivingEntity entity, @Nullable Limb limb) {
        Level level = entity.level();
        if (level.isClientSide()) {
            return;
        }
        long time = level.getGameTime();
        if (time % (long)this.interval != 0L) {
            return;
        }
        if (!entity.isAlive()) {
            return;
        }
        if (this.amount >= 0.0f) {
            entity.heal(this.amount);
        } else {
            DamageSource damageSource = MedSystemDamageTypes.causeToxinDamage(level.registryAccess());
            entity.hurtServer((ServerLevel)level, damageSource, Mth.abs((float)this.amount));
        }
    }

    @Override
    public void cleanup(EffectGroupHolder holder, HealthContainer container, LivingEntity entity, @Nullable Limb limb) {
    }

    @Override
    public void addInformation(EffectGroupHolder holder, Consumer<Component> tooltip, boolean isItemTooltip) {
        float perSecond = 20.0f / (float)this.interval;
        MutableComponent value = Component.translatable((String)(this.amount >= 0.0f ? "label.medsystem.health_recovery" : "label.medsystem.health_loss"), (Object[])new Object[]{Component.literal((String)String.format(Locale.ROOT, "%.1f", Float.valueOf(this.amount * perSecond)))});
        if (isItemTooltip) {
            tooltip.accept(SideEffect.createDescriptionComponent(this.amount > 0.0f ? EffectType.POSITIVE : (this.amount < 0.0f ? EffectType.NEGATIVE : EffectType.NEUTRAL), (Component)value, 1.0f, holder.getDuration(), holder.getDelay()));
        } else {
            tooltip.accept((Component)value.append(" ").append(StatusEffect.getDurationLabel(holder.getDuration())).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    @Override
    public EffectGroupHolder tryToMergeWith(EffectGroupHolder current, EffectGroupHolder other) {
        EffectGroupItem item = other.getItem();
        if (item instanceof HealthEffectGroupItem) {
            HealthEffectGroupItem healthItem = (HealthEffectGroupItem)item;
            if (this.effectId.equals(healthItem.effectId)) {
                return new EffectGroupHolder(item, Math.max(current.getDelay(), other.getDelay()), Math.min(current.getDelay(), other.getDelay()));
            }
        }
        return null;
    }

    @Override
    public EffectGroupItem copy() {
        return new HealthEffectGroupItem(this.effectId, this.amount, this.interval);
    }

    @Override
    public EffectGroupItemType<?> getType() {
        return (EffectGroupItemType)MedSystemStatusEffectGroupItems.HEALTH.value();
    }
}

