/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.effect.group;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import tnt.tarkovcraft.medsystem.api.heal.SideEffect;
import tnt.tarkovcraft.medsystem.common.effect.group.EffectGroupHolder;
import tnt.tarkovcraft.medsystem.common.effect.group.EffectGroupItem;
import tnt.tarkovcraft.medsystem.common.effect.group.EffectGroupItemType;
import tnt.tarkovcraft.medsystem.common.effect.util.EffectType;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.Limb;
import tnt.tarkovcraft.medsystem.common.init.MedSystemStatusEffectGroupItems;

public class MobEffectGroupItem
implements EffectGroupItem {
    public static final MapCodec<MobEffectGroupItem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.MOB_EFFECT.holderByNameCodec().fieldOf("effect").forGetter(t -> t.effect), (App)ExtraCodecs.intRange((int)0, (int)255).optionalFieldOf("amplifier", (Object)0).forGetter(t -> t.amplifier), (App)Codec.BOOL.optionalFieldOf("ambient", (Object)false).forGetter(t -> t.ambient), (App)Codec.BOOL.optionalFieldOf("visible", (Object)true).forGetter(t -> t.visible), (App)Codec.BOOL.optionalFieldOf("showIcon", (Object)true).forGetter(t -> t.showIcon)).apply((Applicative)instance, MobEffectGroupItem::new));
    private final Holder<MobEffect> effect;
    private final int amplifier;
    private final boolean ambient;
    private final boolean visible;
    private final boolean showIcon;

    public MobEffectGroupItem(Holder<MobEffect> effect, int amplifier, boolean ambient, boolean visible, boolean showIcon) {
        this.effect = effect;
        this.amplifier = amplifier;
        this.ambient = ambient;
        this.visible = visible;
        this.showIcon = showIcon;
    }

    public MobEffectGroupItem(Holder<MobEffect> effect, int amplifier, boolean ambient, boolean visible) {
        this(effect, amplifier, ambient, visible, true);
    }

    public MobEffectGroupItem(Holder<MobEffect> effect, int amplifier, boolean ambient) {
        this(effect, amplifier, ambient, true);
    }

    public MobEffectGroupItem(Holder<MobEffect> effect, int amplifier) {
        this(effect, amplifier, false);
    }

    public MobEffectGroupItem(Holder<MobEffect> effect) {
        this(effect, 0);
    }

    @Override
    public void init(EffectGroupHolder holder, HealthContainer container, LivingEntity entity, @Nullable Limb limb) {
        if (entity.level().isClientSide()) {
            MobEffectInstance instance = new MobEffectInstance(this.effect, holder.getDuration(), this.amplifier, this.ambient, this.visible, this.showIcon);
            entity.addEffect(instance);
        }
    }

    @Override
    public void apply(EffectGroupHolder holder, HealthContainer container, LivingEntity entity, @Nullable Limb limb) {
    }

    @Override
    public void cleanup(EffectGroupHolder holder, HealthContainer container, LivingEntity entity, @Nullable Limb limb) {
    }

    @Override
    public void addInformation(EffectGroupHolder holder, Consumer<Component> tooltip, boolean isItemTooltip) {
        MobEffect mobEffect = (MobEffect)this.effect.value();
        MobEffectCategory category = mobEffect.getCategory();
        EffectType effectType = EffectType.byMobEffectCategory(category);
        Object component = this.amplifier < 10 ? mobEffect.getDisplayName().copy().append(CommonComponents.SPACE).append((Component)Component.translatable((String)("enchantment.level." + (this.amplifier + 1)))) : mobEffect.getDisplayName();
        tooltip.accept(SideEffect.createDescriptionComponent(effectType, component, 1.0f, holder.getDuration(), holder.getDelay()));
    }

    @Override
    public EffectGroupItem copy() {
        return new MobEffectGroupItem(this.effect, this.amplifier, this.ambient, this.visible, this.showIcon);
    }

    @Override
    public EffectGroupHolder tryToMergeWith(EffectGroupHolder current, EffectGroupHolder other) {
        return null;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public EffectGroupItemType<?> getType() {
        return (EffectGroupItemType)MedSystemStatusEffectGroupItems.MOB_EFFECT.value();
    }
}

