/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.effect.group;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import tnt.tarkovcraft.core.util.Codecs;
import tnt.tarkovcraft.medsystem.api.heal.SideEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffect;
import tnt.tarkovcraft.medsystem.common.effect.StatusEffectType;
import tnt.tarkovcraft.medsystem.common.effect.group.EffectGroupHolder;
import tnt.tarkovcraft.medsystem.common.effect.group.EffectGroupItem;
import tnt.tarkovcraft.medsystem.common.effect.group.EffectGroupItemType;
import tnt.tarkovcraft.medsystem.common.effect.util.EffectType;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.HealthSystem;
import tnt.tarkovcraft.medsystem.common.health.Limb;
import tnt.tarkovcraft.medsystem.common.init.MedSystemRegistries;
import tnt.tarkovcraft.medsystem.common.init.MedSystemStatusEffectGroupItems;

public class StatusEffectRemovingEffectGroupItem
implements EffectGroupItem {
    public static final MapCodec<StatusEffectRemovingEffectGroupItem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.codec(MedSystemRegistries.Keys.STATUS_EFFECT).fieldOf("tag").forGetter(t -> t.tag), (App)Codecs.simpleEnumCodec(EffectType.class).fieldOf("classification").forGetter(t -> t.classification), (App)ComponentSerialization.CODEC.fieldOf("label").forGetter(t -> t.label)).apply((Applicative)instance, StatusEffectRemovingEffectGroupItem::new));
    private final TagKey<StatusEffectType<?>> tag;
    private final EffectType classification;
    private final Component label;

    public StatusEffectRemovingEffectGroupItem(TagKey<StatusEffectType<?>> tag, EffectType classification, Component label) {
        this.tag = tag;
        this.classification = classification;
        this.label = label;
    }

    @Override
    public void init(EffectGroupHolder holder, HealthContainer container, LivingEntity entity, @Nullable Limb limb) {
    }

    @Override
    public void apply(EffectGroupHolder holder, HealthContainer container, LivingEntity entity, @Nullable Limb limb) {
        Level level = entity.level();
        long time = level.getGameTime();
        if (time % 20L != 0L) {
            return;
        }
        if (container.removeMatchingStatusEffects(this.tag, entity)) {
            HealthSystem.synchronizeEntity(entity);
        }
    }

    @Override
    public void cleanup(EffectGroupHolder holder, HealthContainer container, LivingEntity entity, @Nullable Limb limb) {
    }

    @Override
    public void addInformation(EffectGroupHolder holder, Consumer<Component> tooltip, boolean isItemTooltip) {
        Object component = isItemTooltip ? SideEffect.createDescriptionComponent(this.classification, this.label, 1.0f, holder.getDuration(), holder.getDelay()) : this.label.copy().append(" ").append(StatusEffect.getDurationLabel(holder.getDuration())).withStyle(ChatFormatting.DARK_GRAY);
        tooltip.accept((Component)component);
    }

    @Override
    public EffectGroupItem copy() {
        return new StatusEffectRemovingEffectGroupItem(this.tag, this.classification, this.label);
    }

    @Override
    public EffectGroupHolder tryToMergeWith(EffectGroupHolder current, EffectGroupHolder other) {
        return null;
    }

    @Override
    public EffectGroupItemType<?> getType() {
        return (EffectGroupItemType)MedSystemStatusEffectGroupItems.STATUS_EFFECT_REMOVING.value();
    }
}

