/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.medsystem.common.health.reaction.function;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import tnt.tarkovcraft.core.common.data.number.NumberProvider;
import tnt.tarkovcraft.core.common.data.number.NumberProviderType;
import tnt.tarkovcraft.medsystem.common.health.HealthContainer;
import tnt.tarkovcraft.medsystem.common.health.Limb;
import tnt.tarkovcraft.medsystem.common.health.reaction.function.ChanceFunction;
import tnt.tarkovcraft.medsystem.common.health.reaction.function.ChanceFunctionType;
import tnt.tarkovcraft.medsystem.common.init.MedSystemChanceFunctions;

public class FallDistanceLimitFunction
implements ChanceFunction {
    public static final MapCodec<FallDistanceLimitFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NumberProviderType.complexCodecNoDuration((Codec)ExtraCodecs.POSITIVE_FLOAT).optionalFieldOf("minDistance", (Object)Either.right((Object)Float.valueOf(0.0f))).forGetter(t -> Either.left((Object)t.minDistance)), (App)NumberProviderType.complexCodecNoDuration((Codec)ExtraCodecs.POSITIVE_FLOAT).optionalFieldOf("maxDistance", (Object)Either.right((Object)Float.valueOf(Float.MAX_VALUE))).forGetter(t -> Either.left((Object)t.maxDistance))).apply((Applicative)instance, FallDistanceLimitFunction::new));
    private final NumberProvider minDistance;
    private final NumberProvider maxDistance;

    public FallDistanceLimitFunction(Either<NumberProvider, Float> minDistance, Either<NumberProvider, Float> maxDistance) {
        this.minDistance = NumberProviderType.resolveNoDuration(minDistance);
        this.maxDistance = NumberProviderType.resolveNoDuration(maxDistance);
    }

    @Override
    public float apply(float chance, HealthContainer container, LivingEntity entity, @Nullable DamageSource source, Limb limb) {
        double fallDistance = entity.fallDistance;
        float min = this.minDistance.floatValue();
        float max = this.maxDistance.floatValue();
        if (fallDistance >= (double)min && fallDistance <= (double)max) {
            return chance;
        }
        return 0.0f;
    }

    @Override
    public ChanceFunctionType<?> getType() {
        return (ChanceFunctionType)MedSystemChanceFunctions.FALL_DISTANCE_LIMIT.value();
    }
}

