/*
 * Decompiled with CFR 0.152.
 */
package alicewritesthings.proton.me.shroomdoom.megaliumsystem;

import alicewritesthings.proton.me.shroomdoom.AAShroomDoom;
import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FungusBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LightEngine;
import org.slf4j.Logger;

public class MegaliumBlock
extends Block {
    public static final Logger LOGGER = LogUtils.getLogger();

    public MegaliumBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    private static boolean canBeMegalium(BlockState state, LevelReader levelReader, BlockPos pos) {
        BlockPos blockpos = pos.above();
        BlockState blockabove = levelReader.getBlockState(blockpos);
        if (blockabove.is(Blocks.SNOW) && (Integer)blockabove.getValue((Property)SnowLayerBlock.LAYERS) == 1) {
            return true;
        }
        if (blockabove.getFluidState().getAmount() == 8) {
            return false;
        }
        int i = LightEngine.getLightBlockInto((BlockState)state, (BlockState)blockabove, (Direction)Direction.UP, (int)blockabove.getLightBlock());
        return i < 15;
    }

    private static boolean canPropagate(BlockState state, LevelReader level, BlockPos targetPos) {
        BlockPos aboveTarget = targetPos.above();
        return MegaliumBlock.canBeMegalium(state, level, targetPos) && !level.getFluidState(aboveTarget).is(FluidTags.WATER);
    }

    private static boolean isSpreadable(BlockState target) {
        return target.is(BlockTags.DIRT) || target.is(BlockTags.SAND) || target.is(Blocks.MYCELIUM);
    }

    private static boolean isMulchable(BlockState target) {
        return target.is(BlockTags.LOGS_THAT_BURN);
    }

    protected void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!MegaliumBlock.canBeMegalium(state, (LevelReader)world, pos)) {
            if (!world.isAreaLoaded(pos, 1)) {
                return;
            }
            world.setBlockAndUpdate(pos, Blocks.DIRT.defaultBlockState());
        } else {
            BlockPos posAbove;
            BlockState blockAbove;
            if (!world.isAreaLoaded(pos, 5)) {
                return;
            }
            int threshold = 0;
            BlockState megaliumState = this.defaultBlockState();
            for (int i = 0; i < 8; ++i) {
                BlockPos blockpos = pos.offset(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                BlockState targetState = world.getBlockState(blockpos);
                if (MegaliumBlock.isSpreadable(targetState) && MegaliumBlock.canPropagate(state, (LevelReader)world, blockpos)) {
                    world.setBlockAndUpdate(blockpos, megaliumState);
                    return;
                }
                if (MegaliumBlock.isMulchable(targetState)) {
                    world.setBlockAndUpdate(blockpos, ((Block)AAShroomDoom.ROTTING_MULCH_BLOCK.get()).defaultBlockState());
                    return;
                }
                if (targetState.getBlock() == AAShroomDoom.MEGALIUM_BLOCK.get() && random.nextInt(8) < threshold) break;
            }
            if ((blockAbove = world.getBlockState(posAbove = pos.above())).is(Blocks.AIR) || blockAbove.is(Blocks.LEAF_LITTER)) {
                int value = random.nextInt(20);
                Block randomMush = Blocks.AIR;
                switch (value) {
                    case 0: {
                        randomMush = Blocks.RED_MUSHROOM;
                        break;
                    }
                    case 1: {
                        randomMush = Blocks.BROWN_MUSHROOM;
                        break;
                    }
                    case 2: {
                        randomMush = Blocks.CRIMSON_FUNGUS;
                        break;
                    }
                    case 3: {
                        randomMush = Blocks.WARPED_FUNGUS;
                    }
                }
                world.setBlockAndUpdate(posAbove, randomMush.defaultBlockState());
            } else if (blockAbove.getBlock() instanceof FungusBlock || blockAbove.getBlock() instanceof MushroomBlock) {
                Predicate<BlockPos> isMushroomTreeBlock = position -> world.getBlockState(position).is(BlockTags.WART_BLOCKS) || world.getBlockState(position).is(Blocks.MUSHROOM_STEM);
                if (random.nextInt(8) < threshold) {
                    return;
                }
                if (BlockPos.findClosestMatch((BlockPos)pos, (int)4, (int)3, isMushroomTreeBlock).isEmpty()) {
                    BoneMealItem.applyBonemeal((ItemStack)ItemStack.EMPTY, (Level)world, (BlockPos)posAbove, null);
                }
            }
        }
    }
}

