/*
 * Decompiled with CFR 0.152.
 */
package alicewritesthings.proton.me.shroomdoom.rotsystem;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ColorRGBA;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class RottingMulchBlock
extends ColoredFallingBlock {
    public RottingMulchBlock(ColorRGBA color, BlockBehaviour.Properties props) {
        super(color, props);
    }

    protected void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int chance;
        Predicate<BlockPos> isMulchable = position -> world.getBlockState(position).is(BlockTags.LOGS_THAT_BURN);
        Optional closestMulchable = BlockPos.findClosestMatch((BlockPos)pos, (int)3, (int)5, isMulchable);
        if (closestMulchable.isPresent()) {
            BlockPos targetPos = (BlockPos)closestMulchable.get();
            world.setBlockAndUpdate(targetPos, this.defaultBlockState());
        } else if (world.isEmptyBlock(pos.above()) && (chance = random.nextInt(10)) <= 3) {
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
    }
}

