/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.mmv.modinit.registry;

import com.finndog.mmv.modinit.registry.CustomRegistryLookup;
import com.finndog.mmv.modinit.registry.RegistryEntry;
import com.finndog.mmv.modinit.registry.ResourcefulRegistries;
import com.finndog.mmv.modinit.registry.ResourcefulRegistry;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import org.apache.commons.lang3.tuple.Pair;

public interface CustomRegistry<T>
extends ResourcefulRegistry<T> {
    public static <T, K extends Registry<T>> CustomRegistry<T> of(String modId, ResourceKey<K> key, boolean save, boolean sync, boolean allowModification) {
        final Pair pair = ResourcefulRegistries.createCustomRegistryInternal(modId, key, save, sync, allowModification);
        return new CustomRegistry<T>(){

            @Override
            public CustomRegistryLookup<T> lookup() {
                return (CustomRegistryLookup)((Supplier)pair.getLeft()).get();
            }

            @Override
            public ResourcefulRegistry<T> registry() {
                return (ResourcefulRegistry)pair.getRight();
            }
        };
    }

    public CustomRegistryLookup<T> lookup();

    public ResourcefulRegistry<T> registry();

    @Override
    default public <I extends T> RegistryEntry<I> register(String id, Supplier<I> supplier) {
        return this.registry().register(id, supplier);
    }

    @Override
    default public Collection<RegistryEntry<T>> getEntries() {
        return this.registry().getEntries();
    }

    @Override
    default public Stream<RegistryEntry<T>> stream() {
        return this.registry().stream();
    }

    @Override
    default public void init() {
        this.registry().init();
    }
}

