/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.cumulus.client;

import com.aetherteam.cumulus.Cumulus;
import com.aetherteam.cumulus.CumulusConfig;
import com.aetherteam.cumulus.client.CumulusClient;
import com.aetherteam.cumulus.mixin.mixins.client.accessor.MinecraftAccessor;
import com.aetherteam.cumulus.mixin.mixins.common.accessor.MinecraftServerAccessor;
import com.aetherteam.cumulus.network.packets.SetupLevelDisplayPacket;
import com.aetherteam.cumulus.platform.Services;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_1132;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_34;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_424;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_5498;
import net.minecraft.class_7168;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class WorldDisplayHelper {
    public static boolean menuActive = false;
    @Nullable
    private static class_34 loadedSummary = null;
    public static final Runnable FAIL_RUN = () -> {
        WorldDisplayHelper.resetActive();
        WorldDisplayHelper.resetConfig();
    };

    public static void toggleWorldPreview() {
        if (((Boolean)CumulusConfig.CLIENT.enable_world_preview.get()).booleanValue()) {
            WorldDisplayHelper.enableWorldPreview();
        } else {
            WorldDisplayHelper.disableWorldPreview();
        }
    }

    public static void enableWorldPreview() {
        class_310 minecraft = class_310.method_1551();
        if (Cumulus.SERVER_INSTANCE != null && !menuActive) {
            class_310.method_1551().method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47586, (class_2561)class_2561.method_43471((String)"cumulus_menus.world_preview.toast.title"), (class_2561)class_2561.method_43471((String)"cumulus_menus.world_preview.toast.description")));
            FAIL_RUN.run();
        } else if (minecraft.field_1687 == null) {
            WorldDisplayHelper.loadLevel();
        }
    }

    public static void loadLevel() {
        class_310 minecraft = class_310.method_1551();
        class_34 summary = WorldDisplayHelper.getLevelSummary();
        if (summary != null && minecraft.method_1586().method_230(summary.method_248())) {
            WorldDisplayHelper.setActive();
            minecraft.method_29970((class_437)new class_424((class_2561)class_2561.method_43471((String)"selectWorld.data_read")));
            minecraft.method_41735().method_57784(summary.method_248(), FAIL_RUN);
        } else {
            FAIL_RUN.run();
        }
    }

    public static void enterLoadedLevel() {
        class_310 minecraft = class_310.method_1551();
        class_34 summary = WorldDisplayHelper.getLevelSummary();
        if (summary != null && minecraft.method_1586().method_230(summary.method_248()) && minecraft.method_1576() != null) {
            WorldDisplayHelper.resetStates();
            minecraft.method_29970(null);
        }
    }

    public static void disableWorldPreview() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 != null) {
            WorldDisplayHelper.stopLevel((class_437)new class_424((class_2561)class_2561.method_43471((String)"menu.savingLevel")));
            WorldDisplayHelper.setMenu();
        }
    }

    public static void stopLevel(class_437 screen) {
        WorldDisplayHelper.resetStates();
        class_310 minecraft = class_310.method_1551();
        class_1132 server = minecraft.method_1576();
        if (minecraft.field_1687 != null) {
            if (server != null) {
                server.method_3747(false);
            }
            minecraft.method_56134((class_437)Objects.requireNonNullElse(screen, new class_424((class_2561)class_2561.method_43471((String)"menu.savingLevel"))));
        }
    }

    public static void setMenu() {
        MinecraftAccessor minecraftAccessor = (MinecraftAccessor)class_310.method_1551();
        CumulusClient.MENU_HELPER.setShouldFade(false);
        class_442 screen = CumulusClient.MENU_HELPER.applyMenu(CumulusClient.MENU_HELPER.getActiveMenu());
        if (screen != null) {
            if (minecraftAccessor.cumulus$getCurrentFrameProfile() != null && !minecraftAccessor.cumulus$getCurrentFrameProfile().method_41723()) {
                class_7168.method_41719().ifPresent(timer -> minecraftAccessor.cumulus$setCurrentFrameProfile(timer.method_41721()));
            }
            class_310.method_1551().method_29970((class_437)screen);
        }
    }

    @Nullable
    public static class_34 getLevelSummary() {
        if (loadedSummary == null) {
            if (class_310.method_1551().method_1576() != null) {
                try {
                    class_32.class_5143 source = ((MinecraftServerAccessor)class_310.method_1551().method_1576()).cumulus$getStorageSource();
                    loadedSummary = source.method_29584(source.method_54545());
                    return loadedSummary;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            WorldDisplayHelper.findLevelSummary();
        }
        return loadedSummary;
    }

    public static void findLevelSummary() {
        class_310 minecraft = class_310.method_1551();
        class_32 source = minecraft.method_1586();
        try {
            ArrayList summaryList = new ArrayList((Collection)source.method_43417(source.method_235()).get());
            Collections.sort(summaryList);
            if (!summaryList.isEmpty()) {
                class_34 summary = null;
                for (int i = summaryList.size() - 1; i >= 0; --i) {
                    class_34 s = (class_34)summaryList.get(i);
                    if (s.method_27021() || s.method_33784()) continue;
                    class_32.class_5143 access = source.method_27002(s.method_248());
                    summary = s;
                    access.close();
                }
                if (summary != null) {
                    loadedSummary = summary;
                }
            }
        }
        catch (IOException | InterruptedException | UnsupportedOperationException | ExecutionException e) {
            WorldDisplayHelper.resetActive();
            WorldDisplayHelper.resetConfig();
            e.printStackTrace();
        }
    }

    public static boolean sameSummaries(class_34 summary) {
        class_34 currentSummary = WorldDisplayHelper.getLevelSummary();
        if (currentSummary != null) {
            return currentSummary.method_248().equals(summary.method_248());
        }
        return false;
    }

    public static void resetSummary() {
        loadedSummary = null;
    }

    public static void resetStates() {
        WorldDisplayHelper.resetPlayerState();
        WorldDisplayHelper.resetActive();
    }

    public static void resetPlayerState() {
        class_310.method_1551().field_1690.field_1842 = false;
        class_310.method_1551().field_1690.method_31043(class_5498.field_26664);
    }

    public static void resetConfig() {
        CumulusConfig.CLIENT.enable_world_preview.set((Object)false);
        CumulusConfig.CLIENT.enable_world_preview.save();
    }

    public static void resetActive() {
        menuActive = false;
    }

    public static void setActive() {
        menuActive = true;
    }

    public static boolean isActive() {
        return menuActive;
    }

    public static void setupLevelForDisplay() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.method_1496()) {
            Services.PLATFORM.sendToServer(new SetupLevelDisplayPacket(), new class_8710[0]);
        }
    }
}

