/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.cumulus.platform;

import com.aetherteam.cumulus.Cumulus;
import com.aetherteam.cumulus.api.MenuInitializer;
import com.aetherteam.cumulus.platform.services.IPlatformHelper;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8042;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class FabricPlatformHelper
implements IPlatformHelper {
    @Override
    public List<MenuInitializer> getMenuInitializers() {
        return FabricLoader.getInstance().getEntrypoints("cumulus:menu_initializers", MenuInitializer.class);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void sendToServer(class_8710 payload, class_8710 ... payloads) {
        ClientPlayNetworking.send((class_8710)payload);
        for (class_8710 otherPayload : payloads) {
            ClientPlayNetworking.send((class_8710)otherPayload);
        }
    }

    @Override
    public void sendToPlayer(class_3222 player, class_8710 payload, class_8710 ... payloads) {
        player.field_13987.method_14364(FabricPlatformHelper.makeClientboundPacket(payload, payloads));
    }

    @Override
    public void sendToPlayersInDimension(class_3218 level, class_8710 payload, class_8710 ... payloads) {
        class_2596<?> packet = FabricPlatformHelper.makeClientboundPacket(payload, payloads);
        for (class_3222 serverPlayer : PlayerLookup.world((class_3218)level)) {
            serverPlayer.field_13987.method_14364(packet);
        }
    }

    @Override
    public void sendToPlayersNear(class_3218 level, @Nullable class_3222 excluded, double x, double y, double z, double radius, class_8710 payload, class_8710 ... payloads) {
        class_2596<?> packet = FabricPlatformHelper.makeClientboundPacket(payload, payloads);
        for (class_3222 serverPlayer : PlayerLookup.around((class_3218)level, (class_243)new class_243(x, y, z), (double)radius)) {
            if (serverPlayer == excluded) continue;
            serverPlayer.field_13987.method_14364(packet);
        }
    }

    @Override
    public void sendToAllPlayers(class_8710 payload, class_8710 ... payloads) {
        class_2596<?> packet = FabricPlatformHelper.makeClientboundPacket(payload, payloads);
        for (class_3222 serverPlayer : PlayerLookup.all((MinecraftServer)Cumulus.SERVER_INSTANCE)) {
            serverPlayer.field_13987.method_14364(packet);
        }
    }

    @Override
    public void sendToPlayersTrackingEntity(class_1297 entity, class_8710 payload, class_8710 ... payloads) {
        class_2596<?> packet = FabricPlatformHelper.makeClientboundPacket(payload, payloads);
        for (class_3222 serverPlayer : PlayerLookup.tracking((class_1297)entity)) {
            if (serverPlayer == entity) continue;
            serverPlayer.field_13987.method_14364(packet);
        }
    }

    @Override
    public void sendToPlayersTrackingEntityAndSelf(class_1297 entity, class_8710 payload, class_8710 ... payloads) {
        class_2596<?> packet = FabricPlatformHelper.makeClientboundPacket(payload, payloads);
        LinkedHashSet<class_3222> targets = new LinkedHashSet<class_3222>(PlayerLookup.tracking((class_1297)entity));
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            targets.add(serverPlayer);
        }
        for (class_3222 serverPlayer : targets) {
            if (serverPlayer == entity) continue;
            serverPlayer.field_13987.method_14364(packet);
        }
    }

    @Override
    public void sendToPlayersTrackingChunk(class_3218 level, class_1923 chunkPos, class_8710 payload, class_8710 ... payloads) {
        class_2596<?> packet = FabricPlatformHelper.makeClientboundPacket(payload, payloads);
        for (class_3222 serverPlayer : PlayerLookup.tracking((class_3218)level, (class_1923)chunkPos)) {
            serverPlayer.field_13987.method_14364(packet);
        }
    }

    private static class_2596<?> makeClientboundPacket(class_8710 payload, class_8710 ... payloads) {
        if (payloads.length > 0) {
            ArrayList<class_2658> packets = new ArrayList<class_2658>();
            packets.add(new class_2658(payload));
            for (class_8710 otherPayload : payloads) {
                packets.add(new class_2658(otherPayload));
            }
            return new class_8042(packets);
        }
        return new class_2658(payload);
    }
}

