/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.cumulus.client.event.listeners;

import com.aetherteam.cumulus.client.OpeningScreenEvents;
import com.aetherteam.cumulus.client.event.hooks.WorldPreviewHooks;
import com.aetherteam.cumulus.client.events.LivingEntityRenderEvents;
import com.aetherteam.cumulus.client.events.PlayerRenderEvents;
import com.aetherteam.cumulus.events.CancellableCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_10017;
import net.minecraft.class_10042;
import net.minecraft.class_1007;
import net.minecraft.class_437;
import net.minecraft.class_897;

public class WorldPreviewListener {
    public static void onGuiOpenLowest(class_437 newScreen) {
        WorldPreviewHooks.setupWorldPreview(newScreen);
    }

    public static void onScreenRender(class_437 screen, CancellableCallback callback) {
        if (WorldPreviewHooks.hideScreen(screen)) {
            callback.setCanceled(true);
        }
    }

    public static void onRenderLevelLast() {
        WorldPreviewHooks.renderMenuWithWorld();
    }

    public static void onClientTick() {
        WorldPreviewHooks.tickMenuWhenPaused();
    }

    public static void onRenderPlayer(class_1007 renderer, CancellableCallback callback) {
        boolean hide = WorldPreviewHooks.shouldHidePlayer();
        if (hide) {
            callback.setCanceled(true);
        }
        WorldPreviewHooks.adjustShadow(renderer, hide);
    }

    public static void onRenderEntity(class_10042 renderState, class_897<?, ?> renderer, float partialTick, CancellableCallback callback) {
        boolean hide = WorldPreviewHooks.shouldHideEntity(renderer, (class_10017)renderState, partialTick);
        if (hide) {
            callback.setCanceled(true);
        }
        WorldPreviewHooks.adjustShadow(renderer, hide);
    }

    public static void initEvents() {
        OpeningScreenEvents.POST.register((oldScreen, newScreen) -> {
            WorldPreviewListener.onGuiOpenLowest(newScreen);
            return null;
        });
        WorldRenderEvents.LAST.register(context -> WorldPreviewListener.onRenderLevelLast());
        ClientTickEvents.END_CLIENT_TICK.register(client -> WorldPreviewListener.onClientTick());
        PlayerRenderEvents.BEFORE_RENDER.register((player, renderer, partialTick, poseStack, multiBufferSource, packedLight, callback) -> WorldPreviewListener.onRenderPlayer(renderer, callback));
        LivingEntityRenderEvents.BEFORE_RENDER.register((entityRenderState, renderer, partialTick, poseStack, multiBufferSource, packedLight, callback) -> WorldPreviewListener.onRenderEntity(entityRenderState, renderer, partialTick, callback));
    }
}

