/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.cumulus.network.packets;

import com.aetherteam.cumulus.client.WorldDisplayHelper;
import com.aetherteam.cumulus.mixin.mixins.common.accessor.IntegratedServerAccessor;
import com.google.common.collect.Lists;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;

public record SetupLevelDisplayPacket() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetupLevelDisplayPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cumulus_menus", (String)"setup_level_display"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SetupLevelDisplayPacket> STREAM_CODEC = CustomPacketPayload.codec(SetupLevelDisplayPacket::write, SetupLevelDisplayPacket::decode);

    public void write(RegistryFriendlyByteBuf buf) {
    }

    public static SetupLevelDisplayPacket decode(RegistryFriendlyByteBuf buf) {
        return new SetupLevelDisplayPacket();
    }

    public CustomPacketPayload.Type<SetupLevelDisplayPacket> type() {
        return TYPE;
    }

    public static void execute(SetupLevelDisplayPacket payload, Player player) {
        MinecraftServer server;
        if (player.getServer() != null && (server = player.getServer()) instanceof IntegratedServer) {
            IntegratedServer integratedServer = (IntegratedServer)server;
            IntegratedServerAccessor accessor = (IntegratedServerAccessor)integratedServer;
            server.getConnection().stop();
            if (accessor.cumulus$getLanPinger() != null) {
                accessor.cumulus$getLanPinger().interrupt();
                accessor.cumulus$setLanPinger(null);
            }
            accessor.cumulus$setPublishedPort(-1);
            server.getPlayerList().saveAll();
            Lists.newArrayList((Iterable)server.getPlayerList().getPlayers()).stream().filter(serverPlayer -> !serverPlayer.getUUID().equals(accessor.cumulus$getUUID())).forEach(serverPlayer -> serverPlayer.connection.disconnect((Component)Component.translatable((String)"multiplayer.disconnect.server_shutdown")));
            Minecraft.getInstance().execute(() -> {
                Minecraft.getInstance().options.hideGui = true;
                Minecraft.getInstance().options.setCameraType(CameraType.THIRD_PERSON_BACK);
                WorldDisplayHelper.setMenu();
            });
        }
    }
}

