/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.cumulus.platform;

import com.aetherteam.cumulus.api.CumulusEntrypoint;
import com.aetherteam.cumulus.api.MenuInitializer;
import com.aetherteam.cumulus.platform.services.IPlatformHelper;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.slf4j.Logger;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    public static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public List<MenuInitializer> getMenuInitializers() {
        ArrayList<MenuInitializer> menuInitializers = new ArrayList<MenuInitializer>();
        block4: for (ModFileScanData data : ModList.get().getAllScanData()) {
            for (ModFileScanData.AnnotationData annotationData : data.getAnnotations()) {
                if (!annotationData.annotationType().equals((Object)Type.getType(CumulusEntrypoint.class))) continue;
                try {
                    Class<?> clazz = Class.forName(annotationData.memberName());
                    if (!MenuInitializer.class.isAssignableFrom(clazz)) continue block4;
                    try {
                        menuInitializers.add((MenuInitializer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                    catch (Throwable e) {
                        LOGGER.error("Failed to load MenuInitializer: {}", (Object)annotationData.memberName(), (Object)e);
                    }
                }
                catch (Throwable e) {
                    LOGGER.error("No class from such annotation: {}", (Object)annotationData.memberName(), (Object)e);
                }
                continue block4;
            }
        }
        return menuInitializers;
    }

    @Override
    public void sendToServer(CustomPacketPayload payload, CustomPacketPayload ... payloads) {
        PacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])payloads);
    }

    @Override
    public void sendToPlayer(ServerPlayer player, CustomPacketPayload payload, CustomPacketPayload ... payloads) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])payloads);
    }

    @Override
    public void sendToPlayersInDimension(ServerLevel level, CustomPacketPayload payload, CustomPacketPayload ... payloads) {
        PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)payload, (CustomPacketPayload[])payloads);
    }

    @Override
    public void sendToPlayersNear(ServerLevel level, @Nullable ServerPlayer excluded, double x, double y, double z, double radius, CustomPacketPayload payload, CustomPacketPayload ... payloads) {
        PacketDistributor.sendToPlayersNear((ServerLevel)level, (ServerPlayer)excluded, (double)x, (double)y, (double)z, (double)radius, (CustomPacketPayload)payload, (CustomPacketPayload[])payloads);
    }

    @Override
    public void sendToAllPlayers(CustomPacketPayload payload, CustomPacketPayload ... payloads) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)payload, (CustomPacketPayload[])payloads);
    }

    @Override
    public void sendToPlayersTrackingEntity(Entity entity, CustomPacketPayload payload, CustomPacketPayload ... payloads) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)payload, (CustomPacketPayload[])payloads);
    }

    @Override
    public void sendToPlayersTrackingEntityAndSelf(Entity entity, CustomPacketPayload payload, CustomPacketPayload ... payloads) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)payload, (CustomPacketPayload[])payloads);
    }

    @Override
    public void sendToPlayersTrackingChunk(ServerLevel level, ChunkPos chunkPos, CustomPacketPayload payload, CustomPacketPayload ... payloads) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)chunkPos, (CustomPacketPayload)payload, (CustomPacketPayload[])payloads);
    }
}

