/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.cumulus.client.event.hooks;

import com.aetherteam.cumulus.CumulusConfig;
import com.aetherteam.cumulus.api.MenuHelper;
import com.aetherteam.cumulus.api.Menus;
import com.aetherteam.cumulus.client.CumulusClient;
import com.aetherteam.cumulus.client.WorldDisplayHelper;
import com.aetherteam.cumulus.client.gui.screen.DynamicMenuButton;
import com.aetherteam.cumulus.client.gui.screen.MenuSelectionScreen;
import com.aetherteam.cumulus.mixin.mixins.client.accessor.SplashRendererAccessor;
import com.aetherteam.cumulus.mixin.mixins.client.accessor.TitleScreenAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.Nullable;

public class MenuHooks {
    public static void setLastSplash(Screen screen, MenuHelper menuHelper) {
        TitleScreen titleScreen;
        TitleScreenAccessor screenAccessor;
        SplashRendererAccessor splashRendererAccessor;
        if (screen instanceof TitleScreen && (splashRendererAccessor = (SplashRendererAccessor)(screenAccessor = (TitleScreenAccessor)(titleScreen = (TitleScreen)screen)).cumulus$getSplash()) != null) {
            menuHelper.setLastSplash(splashRendererAccessor.cumulus$getSplash());
        }
    }

    public static void trackFallbacks(Screen screen) {
        if (screen instanceof TitleScreen) {
            TitleScreen titleScreen = (TitleScreen)screen;
            if (((Boolean)CumulusConfig.CLIENT.enable_menu_api.get()).booleanValue()) {
                if (!CumulusClient.MENU_HELPER.doesScreenMatchMenu(titleScreen) || screen.getClass() == TitleScreen.class) {
                    CumulusClient.MENU_HELPER.setFallbackTitleScreen(titleScreen);
                }
            } else if (screen.getClass() == TitleScreen.class) {
                CumulusClient.MENU_HELPER.setFallbackTitleScreen(titleScreen);
            }
        }
    }

    @Nullable
    public static Screen setupCustomMenu(Screen screen, MenuHelper menuHelper) {
        if (screen instanceof TitleScreen && ((Boolean)CumulusConfig.CLIENT.enable_menu_api.get()).booleanValue()) {
            return menuHelper.applyMenu(Menus.get(ResourceLocation.parse((String)((String)CumulusConfig.CLIENT.active_menu.get()))));
        }
        return null;
    }

    public static void resetFade(MenuHelper menuHelper) {
        menuHelper.setShouldFade(false);
    }

    @Nullable
    public static Button setupMenuScreenButton(Screen screen) {
        if (((Boolean)CumulusConfig.CLIENT.enable_menu_api.get()).booleanValue() && ((Boolean)CumulusConfig.CLIENT.enable_menu_list_button.get()).booleanValue() && screen instanceof TitleScreen) {
            return Button.builder((Component)Component.translatable((String)"gui.cumulus_menus.button.menu_list"), pressed -> Minecraft.getInstance().setScreen((Screen)new MenuSelectionScreen(screen))).bounds(screen.width - 62, 4, 58, 20).build();
        }
        return null;
    }

    @Nullable
    public static Button setupToggleWorldButton(Screen screen) {
        if (screen instanceof TitleScreen) {
            DynamicMenuButton dynamicMenuButton = new DynamicMenuButton(new Button.Builder((Component)Component.translatable((String)"gui.cumulus_menus.menu.button.world_preview"), pressed -> {
                CumulusConfig.CLIENT.enable_world_preview.set((Object)((Boolean)CumulusConfig.CLIENT.enable_world_preview.get() == false ? 1 : 0));
                CumulusConfig.CLIENT.enable_world_preview.save();
                WorldDisplayHelper.toggleWorldPreview();
            }).bounds(screen.width - 24 - MenuHooks.getButtonOffset(), 4, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.cumulus_menus.menu.preview"))));
            dynamicMenuButton.setDisplayConfigs(CumulusConfig.CLIENT.enable_world_preview_button);
            return dynamicMenuButton;
        }
        return null;
    }

    @Nullable
    public static Button setupQuickLoadButton(Screen screen) {
        if (screen instanceof TitleScreen) {
            DynamicMenuButton dynamicMenuButton = new DynamicMenuButton(new Button.Builder((Component)Component.translatable((String)"gui.cumulus_menus.menu.button.quick_load"), pressed -> {
                WorldDisplayHelper.enterLoadedLevel();
                Minecraft.getInstance().getMusicManager().stopPlaying();
                Minecraft.getInstance().getSoundManager().stop();
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }).bounds(screen.width - 24 - MenuHooks.getButtonOffset(), 4, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.cumulus_menus.menu.load"))));
            dynamicMenuButton.setOffsetConfigs(CumulusConfig.CLIENT.enable_world_preview_button);
            dynamicMenuButton.setDisplayConfigs(CumulusConfig.CLIENT.enable_world_preview, CumulusConfig.CLIENT.enable_quick_load_button);
            return dynamicMenuButton;
        }
        return null;
    }

    private static int getButtonOffset() {
        return (Boolean)CumulusConfig.CLIENT.enable_menu_api.get() != false && (Boolean)CumulusConfig.CLIENT.enable_menu_list_button.get() != false ? 62 : 0;
    }
}

