/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.cumulus;

import com.aetherteam.cumulus.CumulusConfig;
import com.aetherteam.cumulus.api.Menus;
import com.aetherteam.cumulus.data.providers.CumulusLanguageProvider;
import net.minecraft.SharedConstants;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@Mod(value="cumulus_menus", dist={Dist.CLIENT})
public class CumulusNeoForge {
    public CumulusNeoForge(ModContainer mod, IEventBus bus) {
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        mod.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CumulusConfig.CLIENT_SPEC);
        mod.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    public void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(Menus::init);
    }

    public void dataSetup(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        generator.addProvider(true, (DataProvider)new CumulusLanguageProvider(packOutput, "cumulus_menus"));
        PackMetadataGenerator packMeta = new PackMetadataGenerator(packOutput);
        packMeta.add(PackMetadataSection.TYPE, (Object)new PackMetadataSection((Component)Component.translatable((String)"pack.cumulus_menus.mod.description"), SharedConstants.getCurrentVersion().getPackVersion(PackType.CLIENT_RESOURCES)));
        generator.addProvider(true, (DataProvider)packMeta);
    }
}

