/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.cumulus.client;

import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public interface LanguageProviderBase {
    default public void addTranslations() {
        this.addMenuText("button.world_preview", "W");
        this.addMenuText("button.quick_load", "Q");
        this.addMenuText("preview", "Toggle World");
        this.addMenuText("load", "Quick Load");
        this.addGuiText("button.menu_list", "Menu List");
        this.addGuiText("button.menu_launch", "Launch Menu");
        this.addGuiText("title.menu_selection", "Choose a Main Menu");
        this.addMenuTitle("minecraft", "Minecraft");
        this.addConfig("title", "Cumulus Configuration");
        this.addConfig("section.cumulus.menus.client.toml", "Client Settings");
        this.addConfig("section.cumulus.menus.client.toml.title", "Cumulus Client Configuration");
        this.addConfig("Menu", "Menu");
        this.addConfig("Menu.tooltip", "Config options for menu settings");
        this.addConfig("Menu.button", "Options");
        this.addClientConfig("menu", "enable_menu_api", "Determines whether the Menu API is enabled or not");
        this.addClientConfig("menu", "active_menu", "Sets the current active menu title screen");
        this.addClientConfig("menu", "enable_menu_list_button", "Adds a button to the top right of the main menu screen to open a menu selection screen");
        this.addPackDescription("mod", "Cumulus Resources");
        this.addToast("world_preview", "Server still saving", "Please wait before toggling World preview");
    }

    public String id();

    public void add(String var1, String var2);

    public void addBlock(Supplier<? extends Block> var1, String var2);

    public void add(Block var1, String var2);

    public void addItem(Supplier<? extends Item> var1, String var2);

    public void add(Item var1, String var2);

    public void addItemStack(Supplier<ItemStack> var1, String var2);

    public void add(ItemStack var1, String var2);

    public void addEffect(Supplier<? extends MobEffect> var1, String var2);

    public void add(MobEffect var1, String var2);

    public void addEntityType(Supplier<? extends EntityType<?>> var1, String var2);

    public void add(EntityType<?> var1, String var2);

    public void addTag(Supplier<? extends TagKey<?>> var1, String var2);

    public void add(TagKey<?> var1, String var2);

    default public void addToast(String key, String title, String description) {
        this.add(this.id() + "." + key + ".toast.title", title);
        this.add(this.id() + "." + key + ".toast.description", description);
    }

    default public void addGuiText(String key, String name) {
        this.add("gui." + this.id() + "." + key, name);
    }

    default public void addMenuText(String key, String name) {
        this.addGuiText("menu." + key, name);
    }

    default public void addMenuTitle(String key, String name) {
        this.add(this.id() + ".menu_title." + key, name);
    }

    default public void addConfig(String prefix, String name) {
        this.add(this.id() + ".configuration." + prefix, name);
    }

    default public void addClientConfig(String prefix, String key, String name) {
        this.add("config." + this.id() + ".client." + prefix + "." + key, name);
        this.add("config." + this.id() + ".client." + prefix + "." + key + ".tooltip", name);
    }

    default public void addPackDescription(String packName, String description) {
        this.add("pack." + this.id() + "." + packName + ".description", description);
    }
}

