/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.cumulus.client;

import com.aetherteam.cumulus.Cumulus;
import com.aetherteam.cumulus.CumulusConfig;
import com.aetherteam.cumulus.client.CumulusClient;
import com.aetherteam.cumulus.mixin.mixins.client.accessor.MinecraftAccessor;
import com.aetherteam.cumulus.mixin.mixins.common.accessor.MinecraftServerAccessor;
import com.mojang.blaze3d.systems.TimerQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import org.jetbrains.annotations.Nullable;

public class WorldDisplayHelper {
    public static boolean menuActive = false;
    @Nullable
    private static LevelSummary loadedSummary = null;
    public static final Runnable FAIL_RUN = () -> {
        WorldDisplayHelper.resetActive();
        WorldDisplayHelper.resetConfig();
    };

    public static void toggleWorldPreview() {
        if (((Boolean)CumulusConfig.CLIENT.enable_world_preview.get()).booleanValue()) {
            WorldDisplayHelper.enableWorldPreview();
        } else {
            WorldDisplayHelper.disableWorldPreview();
        }
    }

    public static void enableWorldPreview() {
        Minecraft minecraft = Minecraft.getInstance();
        if (Cumulus.SERVER_INSTANCE != null && !menuActive) {
            Minecraft.getInstance().getToastManager().addToast((Toast)new SystemToast(SystemToast.SystemToastId.WORLD_ACCESS_FAILURE, (Component)Component.translatable((String)"cumulus_menus.world_preview.toast.title"), (Component)Component.translatable((String)"cumulus_menus.world_preview.toast.description")));
            FAIL_RUN.run();
        } else if (minecraft.level == null) {
            WorldDisplayHelper.loadLevel();
        }
    }

    public static void loadLevel() {
        Minecraft minecraft = Minecraft.getInstance();
        LevelSummary summary = WorldDisplayHelper.getLevelSummary();
        if (summary != null && minecraft.getLevelSource().levelExists(summary.getLevelId())) {
            WorldDisplayHelper.setActive();
            minecraft.forceSetScreen((Screen)new GenericMessageScreen((Component)Component.translatable((String)"selectWorld.data_read")));
            minecraft.createWorldOpenFlows().openWorld(summary.getLevelId(), FAIL_RUN);
        } else {
            FAIL_RUN.run();
        }
    }

    public static void enterLoadedLevel() {
        Minecraft minecraft = Minecraft.getInstance();
        LevelSummary summary = WorldDisplayHelper.getLevelSummary();
        if (summary != null && minecraft.getLevelSource().levelExists(summary.getLevelId()) && minecraft.getSingleplayerServer() != null) {
            WorldDisplayHelper.resetStates();
            minecraft.forceSetScreen(null);
        }
    }

    public static void disableWorldPreview() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level != null) {
            WorldDisplayHelper.stopLevel((Screen)new GenericMessageScreen((Component)Component.literal((String)"")));
            WorldDisplayHelper.setMenu();
        }
    }

    public static void stopLevel(@Nullable Screen screen) {
        WorldDisplayHelper.resetStates();
        Minecraft minecraft = Minecraft.getInstance();
        IntegratedServer server = minecraft.getSingleplayerServer();
        if (minecraft.level != null) {
            if (server != null) {
                server.halt(false);
            }
            minecraft.clearClientLevel(Objects.requireNonNullElseGet(screen, () -> new ProgressScreen(true)));
            ((MinecraftAccessor)minecraft).cumulus$setIsLocalServer(false);
        }
    }

    public static void setMenu() {
        MinecraftAccessor minecraftAccessor = (MinecraftAccessor)Minecraft.getInstance();
        CumulusClient.MENU_HELPER.setShouldFade(false);
        TitleScreen screen = CumulusClient.MENU_HELPER.applyMenu(CumulusClient.MENU_HELPER.getActiveMenu());
        if (screen != null) {
            if (minecraftAccessor.cumulus$getCurrentFrameProfile() != null && !minecraftAccessor.cumulus$getCurrentFrameProfile().isDone()) {
                TimerQuery.getInstance().ifPresent(timer -> minecraftAccessor.cumulus$setCurrentFrameProfile(timer.endProfile()));
            }
            Minecraft.getInstance().forceSetScreen((Screen)screen);
        }
    }

    @Nullable
    public static LevelSummary getLevelSummary() {
        if (loadedSummary == null) {
            WorldDisplayHelper.findLevelSummary();
        }
        return loadedSummary;
    }

    public static void findLevelSummary() {
        Minecraft minecraft = Minecraft.getInstance();
        LevelStorageSource source = minecraft.getLevelSource();
        try {
            ArrayList summaryList = new ArrayList((Collection)source.loadLevelSummaries(source.findLevelCandidates()).get());
            Collections.sort(summaryList);
            if (!summaryList.isEmpty()) {
                LevelSummary summary = null;
                for (int i = summaryList.size() - 1; i >= 0; --i) {
                    LevelSummary s = (LevelSummary)summaryList.get(i);
                    if (s.isLocked() || s.isDisabled()) continue;
                    LevelStorageSource.LevelStorageAccess access = source.createAccess(s.getLevelId());
                    summary = s;
                    access.close();
                }
                if (summary != null) {
                    loadedSummary = summary;
                }
            }
        }
        catch (IOException | InterruptedException | UnsupportedOperationException | ExecutionException e) {
            WorldDisplayHelper.resetActive();
            WorldDisplayHelper.resetConfig();
            e.printStackTrace();
        }
    }

    public static boolean sameSummaries(LevelSummary summary) {
        String id = WorldDisplayHelper.getLevelSummary().getLevelId();
        if (Minecraft.getInstance().getSingleplayerServer() != null) {
            id = ((MinecraftServerAccessor)Minecraft.getInstance().getSingleplayerServer()).cumulus$getStorageSource().getLevelId();
        }
        return id.equals(summary.getLevelId());
    }

    public static void resetStates() {
        WorldDisplayHelper.resetPlayerState();
        WorldDisplayHelper.resetActive();
    }

    public static void resetPlayerState() {
        Minecraft.getInstance().options.hideGui = false;
        Minecraft.getInstance().options.setCameraType(CameraType.FIRST_PERSON);
    }

    public static void resetConfig() {
        CumulusConfig.CLIENT.enable_world_preview.set((Object)false);
        CumulusConfig.CLIENT.enable_world_preview.save();
    }

    public static void resetActive() {
        menuActive = false;
    }

    public static void setActive() {
        menuActive = true;
    }

    public static boolean isActive() {
        return menuActive;
    }

    public static void setupLevelForDisplay() {
        Minecraft minecraft = Minecraft.getInstance();
        IntegratedServer server = minecraft.getSingleplayerServer();
        if (server != null) {
            Minecraft.getInstance().options.hideGui = true;
            Minecraft.getInstance().options.setCameraType(CameraType.THIRD_PERSON_BACK);
            WorldDisplayHelper.setMenu();
        }
    }
}

