/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.cumulus.client.gui.screen;

import com.aetherteam.cumulus.client.gui.screen.BuilderMadeButton;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;

public class DynamicMenuButton
extends BuilderMadeButton {
    private final int originX = this.getX();
    private List<ModConfigSpec.ConfigValue<Boolean>> displayConfigs;
    private List<ModConfigSpec.ConfigValue<Boolean>> offsetConfigs;
    public boolean enabled = true;

    public DynamicMenuButton(Button.Builder builder) {
        super(builder.createNarration(DEFAULT_NARRATION));
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.shouldRender()) {
            this.enabled = true;
            this.setX(this.getOriginX() + this.gatherOffsets(this.offsetConfigs));
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        } else {
            this.enabled = false;
        }
        this.active = this.enabled;
        this.visible = this.enabled;
    }

    private boolean shouldRender() {
        for (ModConfigSpec.ConfigValue<Boolean> value : this.displayConfigs) {
            if (((Boolean)value.get()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private int gatherOffsets(@Nullable List<ModConfigSpec.ConfigValue<Boolean>> configs) {
        int offset = 0;
        if (configs != null) {
            for (ModConfigSpec.ConfigValue<Boolean> value : configs) {
                if (!((Boolean)value.get()).booleanValue()) continue;
                offset -= 24;
            }
        }
        return offset;
    }

    @SafeVarargs
    public final void setDisplayConfigs(ModConfigSpec.ConfigValue<Boolean> ... displayConfigs) {
        this.displayConfigs = List.of(displayConfigs);
    }

    @SafeVarargs
    public final void setOffsetConfigs(ModConfigSpec.ConfigValue<Boolean> ... offsetConfigs) {
        this.offsetConfigs = List.of(offsetConfigs);
    }

    public int getOriginX() {
        return this.originX;
    }
}

