package dev.hipposgrumm.armor_trims.api.base;

import dev.hipposgrumm.armor_trims.Armortrims;
import dev.hipposgrumm.armor_trims.api.OverlayRegistry;
import dev.hipposgrumm.armor_trims.api.trimming.ItemOverlay;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

/// Item Overlays
public class ItemOverlays {
    public static final ItemOverlay OTHER = OverlayRegistry.registerItemOverlay(new ResourceLocation(Armortrims.MODID, "other"), new ItemOverlay(new ResourceLocation(Armortrims.MODID, "item/overlay/other_trim")));
    public static final ItemOverlay HEAD  = OverlayRegistry.registerItemOverlay(new ResourceLocation(Armortrims.MODID, "head"),  new ItemOverlay(new ResourceLocation(Armortrims.MODID, "item/overlay/helmet_trim")));
    public static final ItemOverlay CHEST = OverlayRegistry.registerItemOverlay(new ResourceLocation(Armortrims.MODID, "chest"), new ItemOverlay(new ResourceLocation(Armortrims.MODID, "item/overlay/chestplate_trim")));
    public static final ItemOverlay LEGS  = OverlayRegistry.registerItemOverlay(new ResourceLocation(Armortrims.MODID, "legs"),  new ItemOverlay(new ResourceLocation(Armortrims.MODID, "item/overlay/leggings_trim")));
    public static final ItemOverlay FEET  = OverlayRegistry.registerItemOverlay(new ResourceLocation(Armortrims.MODID, "feet"),  new ItemOverlay(new ResourceLocation(Armortrims.MODID, "item/overlay/boots_trim")));

    @ApiStatus.Internal
    public static void register() {
        OverlayRegistry.addCondition((item, overlay) -> {
            Item it = item.func_77973_b();
            if (it instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem) it;
                switch (armorItem.func_185083_B_()) {
                    // This definitely won't confuse people.
                    case HEAD:  return HEAD;
                    case CHEST: return CHEST;
                    case LEGS:  return LEGS;
                    case FEET:  return FEET;
                }
            }
            return overlay;
        });
    }
}
