package dev.hipposgrumm.armor_trims.api.base.item;

import dev.hipposgrumm.armor_trims.api.item.UpgradeSmithingTemplate;
import dev.hipposgrumm.armor_trims.util.ArmortrimsInternalUtils;
import dev.hipposgrumm.armor_trims.util.color.ColorPalette;
import dev.hipposgrumm.armor_trims.util.color.ColorPaletteManager;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SmithingRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
//? if forge {
import net.minecraftforge.registries.ForgeRegistries;
//?}

import java.lang.ref.WeakReference;
import java.util.List;

public class NetheriteUpgradeSmithingTemplate extends UpgradeSmithingTemplate {
    public NetheriteUpgradeSmithingTemplate(ResourceLocation trimIdentifier, Properties properties) {
        super(trimIdentifier, () -> Ingredient.func_199805_a(ArmortrimsInternalUtils.NETHERITE_TAG), /*? if >=1.19 {*//*DiamondColored.create*//*?} else {*/new DiamondColored/*?}*/("tooltip.armor_trims.applyTo.diamond_equipment"), properties);
    }

    public ItemStack getResult(ItemStack baseItem, ItemStack templateItem, ItemStack materialItem, World level) {
        // Make sure the material matches.
        if (!materials().test(materialItem)) return ItemStack.field_190927_a;

        IInventory vanillaRecipeContainer = new Inventory(2);
        vanillaRecipeContainer.func_70299_a(0, baseItem);
        vanillaRecipeContainer.func_70299_a(1, materialItem);

        List<SmithingRecipe> list = level.func_199532_z().func_215370_b(IRecipeType.field_234827_g_, vanillaRecipeContainer, level);
        if (list.isEmpty()) return ItemStack.field_190927_a;

        SmithingRecipe selectedRecipe = list.get(0);
        return selectedRecipe.func_77572_b(vanillaRecipeContainer);
    }

    /// This class allows for the diamond color of the tooltip. A bit unnecessary, but it was fun to write so who cares.
    private static final class DiamondColored /*? if >=1.19 {*//*implements Component*//*?} else {*/extends TranslationTextComponent/*?}*/ {
        private static WeakReference<ColorPalette> diamondColor = new WeakReference<>(null);
        //? if >=1.19
        /*private final MutableComponent base;*/

        public DiamondColored(String key) {
            //? if >=1.19 {
            /*base = Component.translatable(key);
            *///?} else {
            super(key);
            //?}
        }

        //? if >=1.19 {
        /*public static MutableComponent create(String key) {
            return Component.empty().append(new DiamondColored(key));
        }
        *///?}

        public Style func_150256_b() {
            // Get the original Style.
            Style style = /*? if >=1.19 {*//*base*//*?} else {*/super/*?}*/.func_150256_b();
            // Make sure a level is loaded before trying to do tag stuff.
            if (Minecraft.func_71410_x().field_71441_e == null) return style;
            // Get the color.
            // This color is a WeakReference, meaning this class won't stop it from getting munched by the Garbage Collector.
            ColorPalette color = diamondColor.get();
            // If the color doesn't exist (maybe it got munched by the Garbage Collector).
            if (color == null || color.discarded()) {
                // We need diamond.
                //? if forge {
                ResourceLocation diamond = ForgeRegistries.ITEMS.getKey(Items.field_151045_i);
                //?} else {
                /*ResourceLocation diamond = Registry.ITEM.getKey(Items.DIAMOND);
                *///?}

                // Get the color.
                color = ColorPaletteManager.get(diamond);
                if (color == null) return style; // It is very possible for it to not be there.

                // Set the color again. Again, there is nothing here stopping it from being munched by the Garbage Collector.
                // But don't set the color if it's the default one.
                if (color != ColorPalette.DEFAULT) diamondColor = new WeakReference<>(color);
            }
            return style.func_240718_a_(color.textColor());
        }

        //? if >=1.19 {
        /*@Override
        public ComponentContents getContents() {
            return base.getContents();
        }

        @Override
        public List<Component> getSiblings() {
            return base.getSiblings();
        }

        @Override
        public FormattedCharSequence getVisualOrderText() {
            return base.getVisualOrderText();
        }
        *///?}
    }
}
